/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.schema;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.SequenceSchema;
import org.joda.time.DateTimeZone;

@JsonIgnoreProperties(value={"columnNames", "columnNamesIndex"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SequenceSchema.class, name="SequenceSchema")})
public class Schema
implements Serializable {
    private List<String> columnNames;
    @JsonProperty(value="columns")
    private List<ColumnMetaData> columnMetaData;
    private Map<String, Integer> columnNamesIndex;

    private Schema() {
    }

    protected Schema(Builder builder) {
        this.columnMetaData = builder.columnMetaData;
        this.columnNames = new ArrayList<String>();
        for (ColumnMetaData meta : this.columnMetaData) {
            this.columnNames.add(meta.getName());
        }
        this.columnNamesIndex = new HashMap<String, Integer>();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.columnNamesIndex.put(this.columnNames.get(i), i);
        }
    }

    public Schema(@JsonProperty(value="columns") List<ColumnMetaData> columnMetaData) {
        if (columnMetaData == null || columnMetaData.size() == 0) {
            throw new IllegalArgumentException("Column meta data must be non-empty");
        }
        this.columnMetaData = columnMetaData;
        this.columnNames = new ArrayList<String>();
        for (ColumnMetaData meta : this.columnMetaData) {
            this.columnNames.add(meta.getName());
        }
        this.columnNamesIndex = new HashMap<String, Integer>();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.columnNamesIndex.put(this.columnNames.get(i), i);
        }
    }

    public Schema newSchema(List<ColumnMetaData> columnMetaData) {
        return new Schema(columnMetaData);
    }

    public int numColumns() {
        return this.columnNames.size();
    }

    public String getName(int column) {
        return this.columnNames.get(column);
    }

    public ColumnType getType(int column) {
        return this.columnMetaData.get(column).getColumnType();
    }

    public ColumnMetaData getMetaData(int column) {
        return this.columnMetaData.get(column);
    }

    public ColumnMetaData getMetaData(String column) {
        return this.getMetaData(this.getIndexOfColumn(column));
    }

    public List<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames);
    }

    public List<ColumnType> getColumnTypes() {
        ArrayList<ColumnType> list = new ArrayList<ColumnType>(this.columnMetaData.size());
        for (ColumnMetaData md : this.columnMetaData) {
            list.add(md.getColumnType());
        }
        return list;
    }

    public List<ColumnMetaData> getColumnMetaData() {
        return new ArrayList<ColumnMetaData>(this.columnMetaData);
    }

    public int getIndexOfColumn(String columnName) {
        Integer idx = this.columnNamesIndex.get(columnName);
        if (idx == null) {
            throw new NoSuchElementException("Unknown column: \"" + columnName + "\"");
        }
        return idx;
    }

    public boolean hasColumn(String columnName) {
        Integer idx = this.columnNamesIndex.get(columnName);
        return idx != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.numColumns();
        int maxNameLength = 0;
        for (String s : this.getColumnNames()) {
            maxNameLength = Math.max(maxNameLength, s.length());
        }
        sb.append("Schema():\n");
        sb.append(String.format("%-6s", "idx")).append(String.format("%-" + (maxNameLength + 8) + "s", "name")).append(String.format("%-15s", "type")).append("meta data").append("\n");
        for (int i = 0; i < nCol; ++i) {
            String colName = this.getName(i);
            ColumnType type = this.getType(i);
            ColumnMetaData meta = this.getMetaData(i);
            String paddedName = String.format("%-" + (maxNameLength + 8) + "s", "\"" + colName + "\"");
            sb.append(String.format("%-6d", i)).append(paddedName).append(String.format("%-15s", new Object[]{type})).append(meta).append("\n");
        }
        return sb.toString();
    }

    public String toJson() {
        return this.toJacksonString(new JsonFactory());
    }

    public String toYaml() {
        return this.toJacksonString((JsonFactory)new YAMLFactory());
    }

    private String toJacksonString(JsonFactory factory) {
        String str;
        ObjectMapper om = new ObjectMapper(factory);
        om.registerModule((Module)new JodaModule());
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        om.enable(SerializationFeature.INDENT_OUTPUT);
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        om.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        try {
            str = om.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static Schema fromJson(String json) {
        return Schema.fromJacksonString(json, new JsonFactory());
    }

    public static Schema fromYaml(String yaml) {
        return Schema.fromJacksonString(yaml, (JsonFactory)new YAMLFactory());
    }

    private static Schema fromJacksonString(String str, JsonFactory factory) {
        ObjectMapper om = new ObjectMapper(factory);
        om.registerModule((Module)new JodaModule());
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        om.enable(SerializationFeature.INDENT_OUTPUT);
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        om.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        try {
            return (Schema)om.readValue(str, Schema.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<ColumnMetaData> this$columnMetaData = this.getColumnMetaData();
        List<ColumnMetaData> other$columnMetaData = other.getColumnMetaData();
        if (this$columnMetaData == null ? other$columnMetaData != null : !((Object)this$columnMetaData).equals(other$columnMetaData)) {
            return false;
        }
        Map<String, Integer> this$columnNamesIndex = this.columnNamesIndex;
        Map<String, Integer> other$columnNamesIndex = other.columnNamesIndex;
        return !(this$columnNamesIndex == null ? other$columnNamesIndex != null : !((Object)this$columnNamesIndex).equals(other$columnNamesIndex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<ColumnMetaData> $columnMetaData = this.getColumnMetaData();
        result = result * 59 + ($columnMetaData == null ? 43 : ((Object)$columnMetaData).hashCode());
        Map<String, Integer> $columnNamesIndex = this.columnNamesIndex;
        result = result * 59 + ($columnNamesIndex == null ? 43 : ((Object)$columnNamesIndex).hashCode());
        return result;
    }

    public static class Builder {
        List<ColumnMetaData> columnMetaData = new ArrayList<ColumnMetaData>();

        public Builder addColumnDouble(String name) {
            return this.addColumn(new DoubleMetaData(name));
        }

        public Builder addColumnDouble(String name, Double minAllowedValue, Double maxAllowedValue) {
            return this.addColumnDouble(name, minAllowedValue, maxAllowedValue, false, false);
        }

        public Builder addColumnDouble(String name, Double minAllowedValue, Double maxAllowedValue, boolean allowNaN, boolean allowInfinite) {
            return this.addColumn(new DoubleMetaData(name, minAllowedValue, maxAllowedValue, allowNaN, allowInfinite));
        }

        public Builder addColumnsDouble(String ... columnNames) {
            for (String s : columnNames) {
                this.addColumnDouble(s);
            }
            return this;
        }

        public Builder addColumnsDouble(String pattern, int minIdxInclusive, int maxIdxInclusive) {
            return this.addColumnsDouble(pattern, minIdxInclusive, maxIdxInclusive, null, null, false, false);
        }

        public Builder addColumnsDouble(String pattern, int minIdxInclusive, int maxIdxInclusive, Double minAllowedValue, Double maxAllowedValue, boolean allowNaN, boolean allowInfinite) {
            for (int i = minIdxInclusive; i <= maxIdxInclusive; ++i) {
                this.addColumnDouble(String.format(pattern, i), minAllowedValue, maxAllowedValue, allowNaN, allowInfinite);
            }
            return this;
        }

        public Builder addColumnInteger(String name) {
            return this.addColumn(new IntegerMetaData(name));
        }

        public Builder addColumnInteger(String name, Integer minAllowedValue, Integer maxAllowedValue) {
            return this.addColumn(new IntegerMetaData(name, minAllowedValue, maxAllowedValue));
        }

        public Builder addColumnsInteger(String ... names) {
            for (String s : names) {
                this.addColumnInteger(s);
            }
            return this;
        }

        public Builder addColumnsInteger(String pattern, int minIdxInclusive, int maxIdxInclusive) {
            return this.addColumnsInteger(pattern, minIdxInclusive, maxIdxInclusive, null, null);
        }

        public Builder addColumnsInteger(String pattern, int minIdxInclusive, int maxIdxInclusive, Integer minAllowedValue, Integer maxAllowedValue) {
            for (int i = minIdxInclusive; i <= maxIdxInclusive; ++i) {
                this.addColumnInteger(String.format(pattern, i), minAllowedValue, maxAllowedValue);
            }
            return this;
        }

        public Builder addColumnCategorical(String name, String ... stateNames) {
            return this.addColumn(new CategoricalMetaData(name, stateNames));
        }

        public Builder addColumnCategorical(String name, List<String> stateNames) {
            return this.addColumn(new CategoricalMetaData(name, stateNames));
        }

        public Builder addColumnLong(String name) {
            return this.addColumn(new LongMetaData(name));
        }

        public Builder addColumnLong(String name, Long minAllowedValue, Long maxAllowedValue) {
            return this.addColumn(new LongMetaData(name, minAllowedValue, maxAllowedValue));
        }

        public Builder addColumnsLong(String ... names) {
            for (String s : names) {
                this.addColumnLong(s);
            }
            return this;
        }

        public Builder addColumnsLong(String pattern, int minIdxInclusive, int maxIdxInclusive) {
            return this.addColumnsLong(pattern, minIdxInclusive, maxIdxInclusive, null, null);
        }

        public Builder addColumnsLong(String pattern, int minIdxInclusive, int maxIdxInclusive, Long minAllowedValue, Long maxAllowedValue) {
            for (int i = minIdxInclusive; i <= maxIdxInclusive; ++i) {
                this.addColumnLong(String.format(pattern, i), minAllowedValue, maxAllowedValue);
            }
            return this;
        }

        public Builder addColumn(ColumnMetaData metaData) {
            this.columnMetaData.add(metaData);
            return this;
        }

        public Builder addColumnString(String name) {
            return this.addColumn(new StringMetaData(name));
        }

        public Builder addColumnsString(String ... columnNames) {
            for (String s : columnNames) {
                this.addColumnString(s);
            }
            return this;
        }

        public Builder addColumnString(String name, String regex, Integer minAllowableLength, Integer maxAllowableLength) {
            return this.addColumn(new StringMetaData(name, regex, minAllowableLength, maxAllowableLength));
        }

        public Builder addColumnsString(String pattern, int minIdxInclusive, int maxIdxInclusive) {
            return this.addColumnsString(pattern, minIdxInclusive, maxIdxInclusive, null, null, null);
        }

        public Builder addColumnsString(String pattern, int minIdxInclusive, int maxIdxInclusive, String regex, Integer minAllowedLength, Integer maxAllowedLength) {
            for (int i = minIdxInclusive; i <= maxIdxInclusive; ++i) {
                this.addColumnString(String.format(pattern, i), regex, minAllowedLength, maxAllowedLength);
            }
            return this;
        }

        public Builder addColumnTime(String columnName, TimeZone timeZone) {
            return this.addColumnTime(columnName, DateTimeZone.forTimeZone((TimeZone)timeZone));
        }

        public Builder addColumnTime(String columnName, DateTimeZone timeZone) {
            return this.addColumnTime(columnName, timeZone, null, null);
        }

        public Builder addColumnTime(String columnName, DateTimeZone timeZone, Long minValidValue, Long maxValidValue) {
            this.addColumn(new TimeMetaData(columnName, timeZone, minValidValue, maxValidValue));
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

