/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.SequenceComparator;

@JsonIgnoreProperties(value={"inputSchema"})
public class ConvertToSequence {
    private final String keyColumn;
    private final SequenceComparator comparator;
    private Schema inputSchema;

    public ConvertToSequence(@JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="comparator") SequenceComparator comparator) {
        this.keyColumn = keyColumn;
        this.comparator = comparator;
    }

    public SequenceSchema transform(Schema schema) {
        return new SequenceSchema(schema.getColumnMetaData());
    }

    public void setInputSchema(Schema schema) {
        this.inputSchema = schema;
        this.comparator.setSchema(this.transform(schema));
    }

    public String toString() {
        return "ConvertToSequence(keyColumn=\"" + this.keyColumn + "\",comparator=" + this.comparator + ")";
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public SequenceComparator getComparator() {
        return this.comparator;
    }

    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertToSequence)) {
            return false;
        }
        ConvertToSequence other = (ConvertToSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        SequenceComparator this$comparator = this.getComparator();
        SequenceComparator other$comparator = other.getComparator();
        return !(this$comparator == null ? other$comparator != null : !this$comparator.equals(other$comparator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConvertToSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        SequenceComparator $comparator = this.getComparator();
        result = result * 59 + ($comparator == null ? 43 : $comparator.hashCode());
        return result;
    }
}

