/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class FileRecordReader
extends BaseRecordReader {
    protected Iterator<File> iter;
    protected Configuration conf;
    protected File currentFile;
    protected List<String> labels;
    protected boolean appendLabel = false;
    protected InputSplit inputSplit;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.doInitialize(split);
        this.inputSplit = split;
    }

    protected void doInitialize(InputSplit split) {
        URI[] locations = split.locations();
        if (locations != null && locations.length >= 1) {
            if (locations.length > 1) {
                ArrayList allFiles = new ArrayList();
                for (URI location : locations) {
                    File iter = new File(location);
                    if (this.labels == null && this.appendLabel) {
                        File parent = iter.getParentFile().getParentFile();
                        this.labels = new ArrayList<String>();
                        for (File labelDir : parent.listFiles()) {
                            this.labels.add(labelDir.getName());
                        }
                    }
                    if (iter.isDirectory()) {
                        Iterator allFiles2 = FileUtils.iterateFiles((File)iter, null, (boolean)true);
                        while (allFiles2.hasNext()) {
                            allFiles.add(allFiles2.next());
                        }
                        continue;
                    }
                    allFiles.add(iter);
                }
                this.iter = allFiles.listIterator();
            } else {
                File curr = new File(locations[0]);
                this.iter = curr.isDirectory() ? FileUtils.iterateFiles((File)curr, null, (boolean)true) : Collections.singletonList(curr).iterator();
            }
        }
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.appendLabel = conf.getBoolean(APPEND_LABEL, true);
        this.doInitialize(split);
        this.inputSplit = split;
        this.conf = conf;
    }

    @Override
    public List<Writable> next() {
        return this.nextRecord().getRecord();
    }

    private List<Writable> loadFromFile(File next) {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        try {
            ret.add(new Text(FileUtils.readFileToString((File)next)));
            if (this.appendLabel) {
                ret.add(new IntWritable(this.labels.indexOf(next.getParentFile().getName())));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int getCurrentLabel() {
        return this.labels.indexOf(this.currentFile.getParentFile().getName());
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasNext();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void reset() {
        if (this.inputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        try {
            this.doInitialize(this.inputSplit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error during LineRecordReader reset", e);
        }
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        String line;
        this.invokeListeners(uri);
        BufferedReader br = new BufferedReader(new InputStreamReader(dataInputStream));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return Collections.singletonList(new Text(sb.toString()));
    }

    @Override
    public Record nextRecord() {
        File next;
        this.currentFile = next = this.iter.next();
        this.invokeListeners(next);
        List<Writable> ret = this.loadFromFile(next);
        return new org.datavec.api.records.impl.Record(ret, new RecordMetaDataURI(next.toURI(), FileRecordReader.class));
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<Record> out = new ArrayList<Record>();
        for (RecordMetaData meta : recordMetaDatas) {
            URI uri = meta.getURI();
            File f = new File(uri);
            List<Writable> list = this.loadFromFile(f);
            out.add(new org.datavec.api.records.impl.Record(list, meta));
        }
        return out;
    }
}

