/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class CategoricalColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final String value;
    private final Set<String> set;

    public CategoricalColumnCondition(String columnName, ConditionOp op, String value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public CategoricalColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode, ConditionOp op, String value) {
        super(columnName, sequenceConditionMode);
        if (op != ConditionOp.Equal && op != ConditionOp.NotEqual) {
            throw new IllegalArgumentException("Invalid condition op: can only use this constructor with Equal or NotEqual conditions");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public CategoricalColumnCondition(String columnName, ConditionOp op, Set<String> set) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    private CategoricalColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") String value, @JsonProperty(value="set") Set<String> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = value;
        this.set = set;
    }

    public CategoricalColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<String> set) {
        super(columnName, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case Equal: {
                return this.value.equals(writable.toString());
            }
            case NotEqual: {
                return !this.value.equals(writable.toString());
            }
            case InSet: {
                return this.set.contains(writable.toString());
            }
            case NotInSet: {
                return !this.set.contains(writable.toString());
            }
            case LessThan: 
            case LessOrEqual: 
            case GreaterThan: 
            case GreaterOrEqual: {
                throw new UnsupportedOperationException("Cannot use ConditionOp \"" + (Object)((Object)this.op) + "\" on Categorical column");
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "CategoricalColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalColumnCondition)) {
            return false;
        }
        CategoricalColumnCondition other = (CategoricalColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionOp this$op = this.op;
        ConditionOp other$op = other.op;
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Set<String> this$set = this.set;
        Set<String> other$set = other.set;
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CategoricalColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConditionOp $op = this.op;
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Set<String> $set = this.set;
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }
}

