/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class IntegerColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final Integer value;
    private final Set<Integer> set;

    public IntegerColumnCondition(String columnName, ConditionOp op, int value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public IntegerColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, int value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public IntegerColumnCondition(String column, ConditionOp op, Set<Integer> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public IntegerColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Integer> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    private IntegerColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") Integer value, @JsonProperty(value="set") Set<Integer> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = set == null ? value : null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case LessThan: {
                return writable.toInt() < this.value;
            }
            case LessOrEqual: {
                return writable.toInt() <= this.value;
            }
            case GreaterThan: {
                return writable.toInt() > this.value;
            }
            case GreaterOrEqual: {
                return writable.toInt() >= this.value;
            }
            case Equal: {
                return writable.toInt() == this.value.intValue();
            }
            case NotEqual: {
                return writable.toInt() != this.value.intValue();
            }
            case InSet: {
                return this.set.contains(writable.toInt());
            }
            case NotInSet: {
                return !this.set.contains(writable.toInt());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "IntegerColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerColumnCondition)) {
            return false;
        }
        IntegerColumnCondition other = (IntegerColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionOp this$op = this.op;
        ConditionOp other$op = other.op;
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        Integer this$value = this.value;
        Integer other$value = other.value;
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Set<Integer> this$set = this.set;
        Set<Integer> other$set = other.set;
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IntegerColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConditionOp $op = this.op;
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        Integer $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Set<Integer> $set = this.set;
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }
}

