/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.rank;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.writable.comparator.WritableComparator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonIgnoreProperties(value={"inputSchema"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public class CalculateSortedRank
implements Serializable {
    private final String newColumnName;
    private final String sortOnColumn;
    private final WritableComparator comparator;
    private final boolean ascending;
    private Schema inputSchema;

    public CalculateSortedRank(String newColumnName, String sortOnColumn, WritableComparator comparator) {
        this(newColumnName, sortOnColumn, comparator, true);
    }

    public CalculateSortedRank(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="sortOnColumn") String sortOnColumn, @JsonProperty(value="comparator") WritableComparator comparator, @JsonProperty(value="ascending") boolean ascending) {
        this.newColumnName = newColumnName;
        this.sortOnColumn = sortOnColumn;
        this.comparator = comparator;
        this.ascending = ascending;
    }

    public Schema transform(Schema inputSchema) {
        if (inputSchema instanceof SequenceSchema) {
            throw new IllegalStateException("Calculating sorted rank on sequences: not yet supported");
        }
        List<String> origNames = inputSchema.getColumnNames();
        List<ColumnMetaData> origMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(origMeta);
        newMeta.add(new LongMetaData(this.newColumnName, 0L, null));
        return inputSchema.newSchema(newMeta);
    }

    public void setInputSchema(Schema schema) {
        this.inputSchema = schema;
    }

    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public String toString() {
        return "CalculateSortedRank(newColumnName=\"" + this.newColumnName + "\", comparator=" + this.comparator + ")";
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public String getSortOnColumn() {
        return this.sortOnColumn;
    }

    public WritableComparator getComparator() {
        return this.comparator;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateSortedRank)) {
            return false;
        }
        CalculateSortedRank other = (CalculateSortedRank)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        String this$sortOnColumn = this.getSortOnColumn();
        String other$sortOnColumn = other.getSortOnColumn();
        if (this$sortOnColumn == null ? other$sortOnColumn != null : !this$sortOnColumn.equals(other$sortOnColumn)) {
            return false;
        }
        WritableComparator this$comparator = this.getComparator();
        WritableComparator other$comparator = other.getComparator();
        if (this$comparator == null ? other$comparator != null : !this$comparator.equals(other$comparator)) {
            return false;
        }
        return this.isAscending() == other.isAscending();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateSortedRank;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        String $sortOnColumn = this.getSortOnColumn();
        result = result * 59 + ($sortOnColumn == null ? 43 : $sortOnColumn.hashCode());
        WritableComparator $comparator = this.getComparator();
        result = result * 59 + ($comparator == null ? 43 : $comparator.hashCode());
        result = result * 59 + (this.isAscending() ? 79 : 97);
        return result;
    }
}

