/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.window;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.reduce.IReducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.transform.sequence.window.WindowFunction;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
public class ReduceSequenceByWindowTransform
implements Transform {
    private IReducer reducer;
    private WindowFunction windowFunction;
    private Schema inputSchema;

    public ReduceSequenceByWindowTransform(@JsonProperty(value="reducer") IReducer reducer, @JsonProperty(value="windowFunction") WindowFunction windowFunction) {
        this.reducer = reducer;
        this.windowFunction = windowFunction;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (inputSchema != null && !(inputSchema instanceof SequenceSchema)) {
            throw new IllegalArgumentException("Invalid input: input schema must be a SequenceSchema");
        }
        inputSchema = this.windowFunction.transform(inputSchema);
        Schema oneStepSchema = this.reducer.transform(inputSchema);
        List<ColumnMetaData> meta = oneStepSchema.getColumnMetaData();
        return new SequenceSchema(meta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.windowFunction.setInputSchema(inputSchema);
        this.reducer.setInputSchema(this.windowFunction.transform(inputSchema));
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("ReduceSequenceByWindownTransform can only be applied on sequences");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        List<List<List<Writable>>> sequenceAsWindows = this.windowFunction.applyToSequence(sequence);
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (List<List<Writable>> window : sequenceAsWindows) {
            List<Writable> reduced = this.reducer.reduce(window);
            out.add(reduced);
        }
        return out;
    }

    public String toString() {
        return "ReduceSequencbyWindowTransform(reducer=" + this.reducer + ",windowFunction=" + this.windowFunction + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReduceSequenceByWindowTransform)) {
            return false;
        }
        ReduceSequenceByWindowTransform other = (ReduceSequenceByWindowTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IReducer this$reducer = this.reducer;
        IReducer other$reducer = other.reducer;
        if (this$reducer == null ? other$reducer != null : !this$reducer.equals(other$reducer)) {
            return false;
        }
        WindowFunction this$windowFunction = this.windowFunction;
        WindowFunction other$windowFunction = other.windowFunction;
        return !(this$windowFunction == null ? other$windowFunction != null : !this$windowFunction.equals(other$windowFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReduceSequenceByWindowTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IReducer $reducer = this.reducer;
        result = result * 59 + ($reducer == null ? 43 : $reducer.hashCode());
        WindowFunction $windowFunction = this.windowFunction;
        result = result * 59 + ($windowFunction == null ? 43 : $windowFunction.hashCode());
        return result;
    }
}

