/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.parse;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class ParseDoubleTransform
extends BaseTransform {
    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public Schema transform(Schema inputSchema) {
        Schema.Builder newSchema = new Schema.Builder();
        for (int i = 0; i < inputSchema.numColumns(); ++i) {
            if (inputSchema.getType(i) == ColumnType.String) {
                newSchema.addColumnDouble(inputSchema.getMetaData(i).getName());
                continue;
            }
            newSchema.addColumn(inputSchema.getMetaData(i));
        }
        return newSchema.build();
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        ArrayList<Writable> transform = new ArrayList<Writable>();
        for (Writable w : writables) {
            if (w instanceof Text) {
                transform.add(new DoubleWritable(w.toDouble()));
                continue;
            }
            transform.add(w);
        }
        return transform;
    }
}

