/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.time;

import java.util.concurrent.TimeUnit;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnNumber", "asMilliseconds"})
public class TimeMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final long timeQuantity;
    private final TimeUnit timeUnit;
    private final long asMilliseconds;

    public TimeMathOpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="timeQuantity") long timeQuantity, @JsonProperty(value="timeUnit") TimeUnit timeUnit) {
        super(columnName);
        if (mathOp != MathOp.Add && mathOp != MathOp.Subtract && mathOp != MathOp.ScalarMin && mathOp != MathOp.ScalarMax) {
            throw new IllegalArgumentException("Invalid MathOp: only Add/Subtract/ScalarMin/ScalarMax supported");
        }
        if ((mathOp == MathOp.ScalarMin || mathOp == MathOp.ScalarMax) && timeUnit != TimeUnit.MILLISECONDS) {
            throw new IllegalArgumentException("Only valid time unit for ScalarMin/Max is Milliseconds (i.e., timestamp format)");
        }
        this.mathOp = mathOp;
        this.timeQuantity = timeQuantity;
        this.timeUnit = timeUnit;
        this.asMilliseconds = TimeUnit.MILLISECONDS.convert(timeQuantity, timeUnit);
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof TimeMetaData)) {
            throw new IllegalStateException("Cannot execute TimeMathOpTransform on column with type " + oldColumnType);
        }
        return new TimeMetaData(newName, ((TimeMetaData)oldColumnType).getTimeZone());
    }

    @Override
    public Writable map(Writable columnWritable) {
        long currTime = columnWritable.toLong();
        switch (this.mathOp) {
            case Add: {
                return new LongWritable(currTime + this.asMilliseconds);
            }
            case Subtract: {
                return new LongWritable(currTime - this.asMilliseconds);
            }
            case ScalarMax: {
                return new LongWritable(Math.max(this.asMilliseconds, currTime));
            }
            case ScalarMin: {
                return new LongWritable(Math.min(this.asMilliseconds, currTime));
            }
        }
        throw new RuntimeException("Invalid MathOp for TimeMathOpTransform: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "TimeMathOpTransform(mathOp=" + (Object)((Object)this.mathOp) + "," + this.timeQuantity + "-" + (Object)((Object)this.timeUnit) + ")";
    }
}

