/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.sequence;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class SequenceDifferenceTransform
implements Transform {
    private final String columnName;
    private final String newColumnName;
    private final int lookback;
    private final FirstStepMode firstStepMode;
    private final Writable specifiedValueWritable;
    private Schema inputSchema;
    private ColumnType columnType;

    public SequenceDifferenceTransform(String columnName) {
        this(columnName, columnName, 1, FirstStepMode.Default, null);
    }

    public SequenceDifferenceTransform(String columnName, String newColumnName, int lookback) {
        this(columnName, newColumnName, lookback, FirstStepMode.Default, null);
    }

    public SequenceDifferenceTransform(String columnName, String newColumnName, int lookback, FirstStepMode firstStepMode, Writable specifiedValueWritable) {
        if (firstStepMode != FirstStepMode.SpecifiedValue && specifiedValueWritable != null) {
            throw new IllegalArgumentException("Specified value writable provided (" + specifiedValueWritable + ") but firstStepMode != FirstStepMode.SpecifiedValue");
        }
        if (firstStepMode == FirstStepMode.SpecifiedValue && specifiedValueWritable == null) {
            throw new IllegalArgumentException("Specified value writable is null but firstStepMode != FirstStepMode.SpecifiedValue");
        }
        if (lookback <= 0) {
            throw new IllegalArgumentException("Lookback period must be > 0. Got: lookback period = " + lookback);
        }
        this.columnName = columnName;
        this.newColumnName = newColumnName;
        this.lookback = lookback;
        this.firstStepMode = firstStepMode;
        this.specifiedValueWritable = specifiedValueWritable;
    }

    @Override
    public String outputColumnName() {
        return this.columnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.columnName()};
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName()};
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.columnName)) {
            throw new IllegalStateException("Invalid input schema: does not have column with name \"" + this.columnName + "\"\n. All schema names: " + inputSchema.getColumnNames());
        }
        if (!(inputSchema instanceof SequenceSchema)) {
            throw new IllegalStateException("Invalid input schema: expected a SequenceSchema, got " + inputSchema.getClass());
        }
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(inputSchema.numColumns());
        block7: for (ColumnMetaData m : inputSchema.getColumnMetaData()) {
            if (this.columnName.equals(m.getName())) {
                switch (m.getColumnType()) {
                    case Integer: {
                        newMeta.add(new IntegerMetaData(this.newColumnName));
                        continue block7;
                    }
                    case Long: {
                        newMeta.add(new LongMetaData(this.newColumnName));
                        continue block7;
                    }
                    case Double: {
                        newMeta.add(new DoubleMetaData(this.newColumnName));
                        continue block7;
                    }
                    case Float: {
                        newMeta.add(new FloatMetaData(this.newColumnName));
                        continue block7;
                    }
                    case Time: {
                        newMeta.add(new LongMetaData(this.newColumnName));
                        continue block7;
                    }
                }
                throw new IllegalStateException("Cannot perform sequence difference on column of type " + (Object)((Object)m.getColumnType()));
            }
            newMeta.add(m);
        }
        return inputSchema.newSchema(newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        if (!inputSchema.hasColumn(this.columnName)) {
            throw new IllegalStateException("Invalid input schema: does not have column with name \"" + this.columnName + "\"\n. All schema names: " + inputSchema.getColumnNames());
        }
        this.columnType = inputSchema.getMetaData(this.columnName).getColumnType();
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("Only sequence operations are supported for SequenceDifferenceTransform. Attempting to apply SequenceDifferenceTransform on non-sequence data?");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        int columnIdx = this.inputSchema.getIndexOfColumn(this.columnName);
        int numSteps = sequence.size();
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (int i = 0; i < numSteps; ++i) {
            List<Writable> timeStep = sequence.get(i);
            ArrayList<Writable> newTimeStep = new ArrayList<Writable>(timeStep.size());
            for (int j = 0; j < timeStep.size(); ++j) {
                if (j == columnIdx) {
                    if (j < this.lookback && this.firstStepMode == FirstStepMode.SpecifiedValue) {
                        newTimeStep.add(this.specifiedValueWritable);
                        continue;
                    }
                    Writable current = timeStep.get(j);
                    Writable past = sequence.get(Math.max(0, i - this.lookback)).get(j);
                    switch (this.columnType) {
                        case Integer: {
                            newTimeStep.add(new IntWritable(current.toInt() - past.toInt()));
                            break;
                        }
                        case Double: {
                            newTimeStep.add(new DoubleWritable(current.toDouble() - past.toDouble()));
                            break;
                        }
                        case Float: {
                            newTimeStep.add(new FloatWritable(current.toFloat() - past.toFloat()));
                            break;
                        }
                        case Long: 
                        case Time: {
                            newTimeStep.add(new LongWritable(current.toLong() - past.toLong()));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Cannot perform sequence difference on column of type " + (Object)((Object)this.columnType));
                        }
                    }
                    continue;
                }
                newTimeStep.add(timeStep.get(j));
            }
            out.add(newTimeStep);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Only sequence operations are supported for SequenceDifferenceTransform. Attempting to apply SequenceDifferenceTransform on non-sequence data?");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Only sequence operations are supported for SequenceDifferenceTransform. Attempting to apply SequenceDifferenceTransform on non-sequence data?");
    }

    public static enum FirstStepMode {
        Default,
        SpecifiedValue;

    }
}

