/*
 *  * Copyright 2016 Skymind, Inc.
 *  *
 *  *    Licensed under the Apache License, Version 2.0 (the "License");
 *  *    you may not use this file except in compliance with the License.
 *  *    You may obtain a copy of the License at
 *  *
 *  *        http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  *    Unless required by applicable law or agreed to in writing, software
 *  *    distributed under the License is distributed on an "AS IS" BASIS,
 *  *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  *    See the License for the specific language governing permissions and
 *  *    limitations under the License.
 */

package org.datavec.api.transform.quality.columns;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Created by Alex on 5/03/2016.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DoubleQuality extends ColumnQuality {

    private final long countNonReal;
    private final long countNaN;
    private final long countInfinite;

    public DoubleQuality(){
        this(0,0,0,0,0,0,0);
    }

    public DoubleQuality(long countValid, long countInvalid, long countMissing, long countTotal, long countNonReal,
                         long countNaN, long countInfinite){
        super(countValid,countInvalid,countMissing,countTotal);
        this.countNonReal = countNonReal;
        this.countNaN = countNaN;
        this.countInfinite = countInfinite;
    }


    public DoubleQuality add(DoubleQuality other){
        return new DoubleQuality(
                countValid + other.countValid,
                countInvalid + other.countInvalid,
                countMissing + other.countMissing,
                countTotal + other.countTotal,
                countNonReal + other.countNonReal,
                countNaN + other.countNaN,
                countInfinite + other.countInfinite);
    }

    @Override
    public String toString(){
        return "DoubleQuality(" + super.toString() + ", countNonReal=" + countNonReal + ", countNaN="
                + countNaN + ", countInfinite=" + countInfinite + ")";
    }

}
