/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.writer.impl.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.impl.LineRecordWriter;
import org.datavec.api.writable.ArrayWritable;
import org.datavec.api.writable.Writable;

public class LibSvmRecordWriter
extends LineRecordWriter {
    public static final String CLASSIFICATION = "libsvm.classification";

    public LibSvmRecordWriter(File path) throws FileNotFoundException {
        super(path);
    }

    public LibSvmRecordWriter(File path, boolean append) throws FileNotFoundException {
        super(path, append);
    }

    public LibSvmRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
    }

    public LibSvmRecordWriter() {
    }

    @Override
    public void write(Collection<Writable> record) throws IOException {
        List<Object> asList = record instanceof List ? (List<Object>)record : new ArrayList<Writable>(record);
        double response = Double.valueOf(((Writable)asList.get(asList.size() - 1)).toString());
        StringBuilder write = new StringBuilder();
        boolean classification = this.conf.getBoolean(CLASSIFICATION, true);
        if (classification) {
            write.append((int)response);
        } else {
            write.append(response);
        }
        write.append(" ");
        for (int i = 0; i < asList.size() - 1; ++i) {
            try {
                double val = Double.valueOf(((Writable)asList.get(i)).toString());
                if (val == 0.0) continue;
                try {
                    write.append(i + 1 + ":" + Integer.valueOf(((Writable)asList.get(i)).toString()));
                }
                catch (NumberFormatException e) {
                    write.append(i + 1 + ":" + Double.valueOf(((Writable)asList.get(i)).toString()));
                }
                if (i >= asList.size() - 1) continue;
                write.append(" ");
                continue;
            }
            catch (NumberFormatException e) {
                Writable w = (Writable)asList.get(i);
                if (w instanceof ArrayWritable) {
                    ArrayWritable a = (ArrayWritable)w;
                    for (long j = 0L; j < a.length(); ++j) {
                        double val = a.getDouble(j);
                        if (val == 0.0) continue;
                        write.append(j + 1L + ":" + a.getDouble(j));
                        if (j >= a.length() - 1L) continue;
                        write.append(" ");
                    }
                    continue;
                }
                throw e;
            }
        }
        this.out.write(write.toString().trim().getBytes());
        this.out.write("\n".getBytes());
    }
}

