/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class LongColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final Long value;
    private final Set<Long> set;

    public LongColumnCondition(String columnName, ConditionOp op, long value) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public LongColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, long value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public LongColumnCondition(String column, ConditionOp op, Set<Long> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public LongColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Long> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = null;
        this.set = set;
    }

    private LongColumnCondition(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="op") ConditionOp op, @JsonProperty(value="value") long value, @JsonProperty(value="set") Set<Long> set) {
        super(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
        this.op = op;
        this.value = set == null ? Long.valueOf(value) : null;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case LessThan: {
                return writable.toLong() < this.value;
            }
            case LessOrEqual: {
                return writable.toLong() <= this.value;
            }
            case GreaterThan: {
                return writable.toLong() > this.value;
            }
            case GreaterOrEqual: {
                return writable.toLong() >= this.value;
            }
            case Equal: {
                return writable.toLong() == this.value.longValue();
            }
            case NotEqual: {
                return writable.toLong() != this.value.longValue();
            }
            case InSet: {
                return this.set.contains(writable.toLong());
            }
            case NotInSet: {
                return !this.set.contains(writable.toLong());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "LongColumnCondition(columnName=\"" + this.columnName + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : this.value) + ")";
    }

    @Override
    public boolean condition(Object input) {
        Number n = (Number)input;
        switch (this.op) {
            case LessThan: {
                return n.longValue() < this.value;
            }
            case LessOrEqual: {
                return n.longValue() <= this.value;
            }
            case GreaterThan: {
                return n.longValue() > this.value;
            }
            case GreaterOrEqual: {
                return n.longValue() >= this.value;
            }
            case Equal: {
                return n.longValue() == this.value.longValue();
            }
            case NotEqual: {
                return n.longValue() != this.value.longValue();
            }
            case InSet: {
                return this.set.contains(n.longValue());
            }
            case NotInSet: {
                return !this.set.contains(n.longValue());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongColumnCondition)) {
            return false;
        }
        LongColumnCondition other = (LongColumnCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionOp this$op = this.getOp();
        ConditionOp other$op = other.getOp();
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        Long this$value = this.getValue();
        Long other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Set<Long> this$set = this.getSet();
        Set<Long> other$set = other.getSet();
        return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LongColumnCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ConditionOp $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        Long $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Set<Long> $set = this.getSet();
        result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
        return result;
    }

    public ConditionOp getOp() {
        return this.op;
    }

    public Long getValue() {
        return this.value;
    }

    public Set<Long> getSet() {
        return this.set;
    }
}

