/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.join;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Writable;

public class Join
implements Serializable {
    private JoinType joinType;
    private Schema leftSchema;
    private Schema rightSchema;
    private String[] joinColumnsLeft;
    private String[] joinColumnsRight;

    private Join(Builder builder) {
        this.joinType = builder.joinType;
        this.leftSchema = builder.leftSchema;
        this.rightSchema = builder.rightSchema;
        this.joinColumnsLeft = builder.joinColumnsLeft;
        this.joinColumnsRight = builder.joinColumnsRight;
        if (this.joinType == null) {
            throw new IllegalArgumentException("Join type cannot be null");
        }
        if (this.leftSchema == null) {
            throw new IllegalArgumentException("Left schema cannot be null");
        }
        if (this.rightSchema == null) {
            throw new IllegalArgumentException("Right schema cannot be null");
        }
        if (this.joinColumnsLeft == null || this.joinColumnsLeft.length == 0) {
            throw new IllegalArgumentException("Invalid left join columns: " + (this.joinColumnsLeft == null ? null : Arrays.toString(this.joinColumnsLeft)));
        }
        if (this.joinColumnsRight == null || this.joinColumnsRight.length == 0) {
            throw new IllegalArgumentException("Invalid right join columns: " + (this.joinColumnsRight == null ? null : Arrays.toString(this.joinColumnsRight)));
        }
        for (String leftCol : this.joinColumnsLeft) {
            if (this.leftSchema.hasColumn(leftCol)) continue;
            throw new IllegalArgumentException("Cannot perform join: left join column \"" + leftCol + "\" does not exist in left schema");
        }
        for (String rightCol : this.joinColumnsRight) {
            if (this.rightSchema.hasColumn(rightCol)) continue;
            throw new IllegalArgumentException("Cannot perform join: right join column \"" + rightCol + "\" does not exist in right schema");
        }
    }

    public Schema getOutputSchema() {
        if (this.leftSchema == null) {
            throw new IllegalStateException("Left schema is not set (null)");
        }
        if (this.rightSchema == null) {
            throw new IllegalStateException("Right schema is not set (null)");
        }
        if (this.joinColumnsLeft == null) {
            throw new IllegalStateException("Left key columns are not set (null)");
        }
        if (this.joinColumnsRight == null) {
            throw new IllegalArgumentException("Right key columns are not set (null");
        }
        ArrayList<ColumnMetaData> metaDataOut = new ArrayList<ColumnMetaData>(this.leftSchema.getColumnMetaData());
        HashSet keySetRight = new HashSet();
        Collections.addAll(keySetRight, this.joinColumnsRight);
        for (ColumnMetaData rightMeta : this.rightSchema.getColumnMetaData()) {
            if (keySetRight.contains(rightMeta.getName())) continue;
            metaDataOut.add(rightMeta);
        }
        return this.leftSchema.newSchema(metaDataOut);
    }

    public List<Writable> joinExamples(List<Writable> leftExample, List<Writable> rightExample) {
        ArrayList<Writable> out = new ArrayList<Writable>();
        if (leftExample == null) {
            if (rightExample == null) {
                throw new IllegalArgumentException("Cannot join examples: Both examples are null (max 1 allowed to be null)");
            }
            int nLeft = this.leftSchema.numColumns();
            List<String> leftNames = this.leftSchema.getColumnNames();
            int keysSoFar = 0;
            for (int i = 0; i < nLeft; ++i) {
                String name = leftNames.get(i);
                if (ArrayUtils.contains((Object[])this.joinColumnsLeft, (Object)name)) {
                    String rightKeyName = this.joinColumnsRight[keysSoFar];
                    int idxOfRightKey = this.rightSchema.getIndexOfColumn(rightKeyName);
                    out.add(rightExample.get(idxOfRightKey));
                    continue;
                }
                out.add(NullWritable.INSTANCE);
            }
        } else {
            out.addAll(leftExample);
        }
        List<String> rightNames = this.rightSchema.getColumnNames();
        if (rightExample == null) {
            int nRight = this.rightSchema.numColumns();
            for (int i = 0; i < nRight; ++i) {
                String name = rightNames.get(i);
                if (ArrayUtils.contains((Object[])this.joinColumnsRight, (Object)name)) continue;
                out.add(NullWritable.INSTANCE);
            }
        } else {
            for (int i = 0; i < rightExample.size(); ++i) {
                String name = rightNames.get(i);
                if (ArrayUtils.contains((Object[])this.joinColumnsRight, (Object)name)) continue;
                out.add(rightExample.get(i));
            }
        }
        return out;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Schema getLeftSchema() {
        return this.leftSchema;
    }

    public Schema getRightSchema() {
        return this.rightSchema;
    }

    public String[] getJoinColumnsLeft() {
        return this.joinColumnsLeft;
    }

    public String[] getJoinColumnsRight() {
        return this.joinColumnsRight;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public void setLeftSchema(Schema leftSchema) {
        this.leftSchema = leftSchema;
    }

    public void setRightSchema(Schema rightSchema) {
        this.rightSchema = rightSchema;
    }

    public void setJoinColumnsLeft(String[] joinColumnsLeft) {
        this.joinColumnsLeft = joinColumnsLeft;
    }

    public void setJoinColumnsRight(String[] joinColumnsRight) {
        this.joinColumnsRight = joinColumnsRight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JoinType this$joinType = this.getJoinType();
        JoinType other$joinType = other.getJoinType();
        if (this$joinType == null ? other$joinType != null : !((Object)((Object)this$joinType)).equals((Object)other$joinType)) {
            return false;
        }
        Schema this$leftSchema = this.getLeftSchema();
        Schema other$leftSchema = other.getLeftSchema();
        if (this$leftSchema == null ? other$leftSchema != null : !((Object)this$leftSchema).equals(other$leftSchema)) {
            return false;
        }
        Schema this$rightSchema = this.getRightSchema();
        Schema other$rightSchema = other.getRightSchema();
        if (this$rightSchema == null ? other$rightSchema != null : !((Object)this$rightSchema).equals(other$rightSchema)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getJoinColumnsLeft(), other.getJoinColumnsLeft())) {
            return false;
        }
        return Arrays.deepEquals(this.getJoinColumnsRight(), other.getJoinColumnsRight());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Join;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JoinType $joinType = this.getJoinType();
        result = result * 59 + ($joinType == null ? 43 : ((Object)((Object)$joinType)).hashCode());
        Schema $leftSchema = this.getLeftSchema();
        result = result * 59 + ($leftSchema == null ? 43 : ((Object)$leftSchema).hashCode());
        Schema $rightSchema = this.getRightSchema();
        result = result * 59 + ($rightSchema == null ? 43 : ((Object)$rightSchema).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getJoinColumnsLeft());
        result = result * 59 + Arrays.deepHashCode(this.getJoinColumnsRight());
        return result;
    }

    public String toString() {
        return "Join(joinType=" + (Object)((Object)this.getJoinType()) + ", leftSchema=" + this.getLeftSchema() + ", rightSchema=" + this.getRightSchema() + ", joinColumnsLeft=" + Arrays.deepToString(this.getJoinColumnsLeft()) + ", joinColumnsRight=" + Arrays.deepToString(this.getJoinColumnsRight()) + ")";
    }

    public static class Builder {
        private JoinType joinType;
        private Schema leftSchema;
        private Schema rightSchema;
        private String[] joinColumnsLeft;
        private String[] joinColumnsRight;

        public Builder(JoinType type) {
            this.joinType = type;
        }

        public Builder setSchemas(Schema left, Schema right) {
            this.leftSchema = left;
            this.rightSchema = right;
            return this;
        }

        @Deprecated
        public Builder setKeyColumns(String ... keyColumnNames) {
            return this.setJoinColumns(keyColumnNames);
        }

        @Deprecated
        public Builder setKeyColumnsLeft(String ... keyColumnNames) {
            return this.setJoinColumnsLeft(keyColumnNames);
        }

        @Deprecated
        public Builder setKeyColumnsRight(String ... keyColumnNames) {
            return this.setJoinColumnsRight(keyColumnNames);
        }

        public Builder setJoinColumns(String ... joinColumnNames) {
            this.setJoinColumnsLeft(joinColumnNames);
            return this.setJoinColumnsRight(joinColumnNames);
        }

        public Builder setJoinColumnsLeft(String ... joinColumnNames) {
            this.joinColumnsLeft = joinColumnNames;
            return this;
        }

        public Builder setJoinColumnsRight(String ... joinColumnNames) {
            this.joinColumnsRight = joinColumnNames;
            return this;
        }

        public Join build() {
            if (this.leftSchema == null || this.rightSchema == null) {
                throw new IllegalStateException("Cannot build Join: left and/or right schemas are null");
            }
            return new Join(this);
        }
    }

    public static enum JoinType {
        Inner,
        LeftOuter,
        RightOuter,
        FullOuter;

    }
}

