/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.datavec.api.berkeley.Triple;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataLineInterval;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.csv.CSVRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class CSVNLinesSequenceRecordReader
extends CSVRecordReader
implements SequenceRecordReader {
    public static final String LINES_PER_SEQUENCE = NAME_SPACE + ".nlinespersequence";
    private int nLinesPerSequence;
    private String delimiter;

    public CSVNLinesSequenceRecordReader() {
        this(10);
    }

    public CSVNLinesSequenceRecordReader(int nLinesPerSequence) {
        this(nLinesPerSequence, 0, String.valueOf(','));
    }

    public CSVNLinesSequenceRecordReader(int nLinesPerSequence, int skipNumLines, String delimiter) {
        super(skipNumLines);
        this.delimiter = delimiter;
        this.nLinesPerSequence = nLinesPerSequence;
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.nLinesPerSequence = conf.getInt(LINES_PER_SEQUENCE, this.nLinesPerSequence);
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        if (!super.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        ArrayList<List<Writable>> sequence = new ArrayList<List<Writable>>();
        int count = 0;
        while (count++ < this.nLinesPerSequence && super.hasNext()) {
            sequence.add(super.next());
        }
        return sequence;
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading CSV data from DataInputStream not yet implemented");
    }

    @Override
    public SequenceRecord nextSequence() {
        int lineBefore = this.lineIndex;
        List<List<Writable>> record = this.sequenceRecord();
        int lineAfter = this.lineIndex;
        URI uri = this.locations == null || this.locations.length < 1 ? null : this.locations[this.splitIndex];
        RecordMetaDataLineInterval meta = new RecordMetaDataLineInterval(lineBefore, lineAfter - 1, uri, CSVNLinesSequenceRecordReader.class);
        return new org.datavec.api.records.impl.SequenceRecord(record, meta);
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadSequenceFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        int currentLineIdx;
        ArrayList list = new ArrayList();
        Iterator<RecordMetaData> iter = recordMetaDatas.iterator();
        int count = 0;
        while (iter.hasNext()) {
            RecordMetaData rmd = iter.next();
            if (!(rmd instanceof RecordMetaDataLineInterval)) {
                throw new IllegalArgumentException("Invalid metadata; expected RecordMetaDataLineInterval instance; got: " + rmd);
            }
            list.add(new Triple(count++, (RecordMetaDataLineInterval)rmd, new ArrayList()));
        }
        Collections.sort(list, new Comparator<Triple<Integer, RecordMetaDataLineInterval, List<List<Writable>>>>(){

            @Override
            public int compare(Triple<Integer, RecordMetaDataLineInterval, List<List<Writable>>> o1, Triple<Integer, RecordMetaDataLineInterval, List<List<Writable>>> o2) {
                return Integer.compare(o1.getSecond().getLineNumberStart(), o2.getSecond().getLineNumberStart());
            }
        });
        Iterator<String> lineIter = this.getIterator(0);
        String line = lineIter.next();
        for (currentLineIdx = 0; currentLineIdx < this.skipNumLines; ++currentLineIdx) {
            line = lineIter.next();
        }
        for (Triple triple : list) {
            int n = ((RecordMetaDataLineInterval)triple.getSecond()).getLineNumberStart();
            int nextEndLine = ((RecordMetaDataLineInterval)triple.getSecond()).getLineNumberEnd();
            while (currentLineIdx < n && lineIter.hasNext()) {
                line = lineIter.next();
                ++currentLineIdx;
            }
            while (currentLineIdx <= nextEndLine && (lineIter.hasNext() || currentLineIdx == nextEndLine)) {
                String[] split = line.split(this.delimiter, -1);
                ArrayList<Text> writables = new ArrayList<Text>();
                for (String s : split) {
                    writables.add(new Text(s));
                }
                ((List)triple.getThird()).add(writables);
                ++currentLineIdx;
                if (!lineIter.hasNext()) continue;
                line = lineIter.next();
            }
        }
        this.closeIfRequired(lineIter);
        Collections.sort(list, new Comparator<Triple<Integer, RecordMetaDataLineInterval, List<List<Writable>>>>(){

            @Override
            public int compare(Triple<Integer, RecordMetaDataLineInterval, List<List<Writable>>> o1, Triple<Integer, RecordMetaDataLineInterval, List<List<Writable>>> o2) {
                return Integer.compare(o1.getFirst(), o2.getFirst());
            }
        });
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        for (Triple triple : list) {
            out.add(new org.datavec.api.records.impl.SequenceRecord((List)triple.getThird(), (RecordMetaData)triple.getSecond()));
        }
        return out;
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) {
        throw new UnsupportedOperationException("Not supported");
    }
}

