/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class InfiniteColumnCondition
extends BaseColumnCondition {
    public InfiniteColumnCondition(String columnName) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
    }

    public InfiniteColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode) {
        super(columnName, sequenceConditionMode);
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return Double.isInfinite(writable.toDouble());
    }

    @Override
    public boolean condition(Object input) {
        return Double.isInfinite(((Number)input).doubleValue());
    }

    @Override
    public String toString() {
        return "InfiniteColumnCondition()";
    }
}

