/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Log2Normalizer
extends BaseDoubleTransform {
    protected static final double log2 = Math.log(2.0);
    protected final double columnMean;
    protected final double columnMin;
    protected final double scalingFactor;

    public Log2Normalizer(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnMean") double columnMean, @JsonProperty(value="columnMin") double columnMin, @JsonProperty(value="scalingFactor") double scalingFactor) {
        super(columnName);
        if (Double.isNaN(columnMean) || Double.isInfinite(columnMean)) {
            throw new IllegalArgumentException("Invalid input: column mean cannot be null/infinite (is: " + columnMean + ")");
        }
        this.columnMean = columnMean;
        this.columnMin = columnMin;
        this.scalingFactor = scalingFactor;
    }

    @Override
    public Writable map(Writable writable) {
        double val = writable.toDouble();
        if (Double.isNaN(val)) {
            return new DoubleWritable(0.0);
        }
        return new DoubleWritable(this.normMean(val));
    }

    private double log2(double x) {
        return Math.log(x) / log2;
    }

    private double normMean(double in) {
        return this.scalingFactor * this.log2((in - this.columnMin) / (this.columnMean - this.columnMin) + 1.0);
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnMeta) {
        return new DoubleMetaData(newColumnName, 0.0, null);
    }

    @Override
    public String toString() {
        return "Log2Normalizer(columnMean=" + this.columnMean + ",columnMin=" + this.columnMin + ",scalingFactor=" + this.scalingFactor + ")";
    }

    @Override
    public Object map(Object input) {
        Number n = (Number)input;
        double val = n.doubleValue();
        if (Double.isNaN(val)) {
            return new DoubleWritable(0.0);
        }
        return this.normMean(val);
    }
}

