/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.transform;

import java.beans.ConstructorProperties;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.transform.TransformProcess;
import org.datavec.api.writable.Writable;

public class TransformProcessRecordReader
implements RecordReader {
    private RecordReader recordReader;
    private TransformProcess transformProcess;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.recordReader.initialize(split);
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.recordReader.initialize(conf, split);
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    @Override
    public List<Writable> next(int num) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Writable> next() {
        return this.transformProcess.execute(this.recordReader.next());
    }

    @Override
    public boolean hasNext() {
        return this.recordReader.hasNext();
    }

    @Override
    public List<String> getLabels() {
        return this.recordReader.getLabels();
    }

    @Override
    public void reset() {
        this.recordReader.reset();
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.transformProcess.execute(this.recordReader.record(uri, dataInputStream));
    }

    @Override
    public Record nextRecord() {
        Record next = this.recordReader.nextRecord();
        return new org.datavec.api.records.impl.Record(this.transformProcess.execute(next.getRecord()), next.getMetaData());
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.recordReader.loadFromMetaData(recordMetaData);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        return this.recordReader.loadFromMetaData(recordMetaDatas);
    }

    @Override
    public List<RecordListener> getListeners() {
        return this.recordReader.getListeners();
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.recordReader.setListeners(listeners);
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.recordReader.setListeners(listeners);
    }

    @Override
    public void close() throws IOException {
        this.recordReader.close();
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return this.recordReader.getConf();
    }

    @ConstructorProperties(value={"recordReader", "transformProcess"})
    public TransformProcessRecordReader(RecordReader recordReader, TransformProcess transformProcess) {
        this.recordReader = recordReader;
        this.transformProcess = transformProcess;
    }
}

