/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.serde.JsonSerializer;
import org.datavec.api.transform.serde.YamlSerializer;
import org.nd4j.shade.jackson.core.TreeNode;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.node.ArrayNode;

public class DataAnalysis
implements Serializable {
    private static final String COL_NAME = "columnName";
    private static final String COL_IDX = "columnIndex";
    private static final String COL_TYPE = "columnType";
    private static final String CATEGORICAL_STATE_NAMES = "stateNames";
    private static final String ANALYSIS = "analysis";
    private static final String DATA_ANALYSIS = "DataAnalysis";
    private Schema schema;
    private List<ColumnAnalysis> columnAnalysis;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.schema.numColumns();
        int maxNameLength = 0;
        for (String s : this.schema.getColumnNames()) {
            maxNameLength = Math.max(maxNameLength, s.length());
        }
        sb.append(String.format("%-6s", "idx")).append(String.format("%-" + (maxNameLength + 8) + "s", "name")).append(String.format("%-15s", "type")).append(ANALYSIS).append("\n");
        for (int i = 0; i < nCol; ++i) {
            String colName = this.schema.getName(i);
            ColumnType type = this.schema.getType(i);
            ColumnAnalysis analysis = this.columnAnalysis.get(i);
            String paddedName = String.format("%-" + (maxNameLength + 8) + "s", "\"" + colName + "\"");
            sb.append(String.format("%-6d", i)).append(paddedName).append(String.format("%-15s", new Object[]{type})).append(analysis).append("\n");
        }
        return sb.toString();
    }

    public ColumnAnalysis getColumnAnalysis(String column) {
        return this.columnAnalysis.get(this.schema.getIndexOfColumn(column));
    }

    public String toJson() {
        return this.toJson(this.getJsonRepresentation());
    }

    public String toYaml() {
        return this.toYaml(this.getJsonRepresentation());
    }

    public static DataAnalysis fromJson(String json) {
        ObjectMapper om = new JsonSerializer().getObjectMapper();
        return DataAnalysis.fromMapper(om, json);
    }

    public static DataAnalysis fromYaml(String yaml) {
        ObjectMapper om = new YamlSerializer().getObjectMapper();
        return DataAnalysis.fromMapper(om, yaml);
    }

    private static DataAnalysis fromMapper(ObjectMapper om, String json) {
        ArrayList<ColumnMetaData> meta = new ArrayList<ColumnMetaData>();
        ArrayList<ColumnAnalysis> analysis = new ArrayList<ColumnAnalysis>();
        try {
            JsonNode node = om.readTree(json);
            Iterator fieldNames = node.fieldNames();
            boolean hasDataAnalysis = false;
            while (fieldNames.hasNext()) {
                if (!DATA_ANALYSIS.equals(fieldNames.next())) continue;
                hasDataAnalysis = true;
                break;
            }
            if (!hasDataAnalysis) {
                throw new RuntimeException();
            }
            ArrayNode arrayNode = (ArrayNode)node.get(DATA_ANALYSIS);
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode analysisNode = arrayNode.get(i);
                String name = analysisNode.get(COL_NAME).asText();
                int idx = analysisNode.get(COL_IDX).asInt();
                ColumnType type = ColumnType.valueOf(analysisNode.get(COL_TYPE).asText());
                JsonNode daNode = analysisNode.get(ANALYSIS);
                ColumnAnalysis dataAnalysis = (ColumnAnalysis)om.treeToValue((TreeNode)daNode, ColumnAnalysis.class);
                if (type == ColumnType.Categorical) {
                    ArrayNode an = (ArrayNode)analysisNode.get(CATEGORICAL_STATE_NAMES);
                    ArrayList<String> stateNames = new ArrayList<String>(an.size());
                    Iterator iter = an.elements();
                    while (iter.hasNext()) {
                        stateNames.add(((JsonNode)iter.next()).asText());
                    }
                    meta.add(new CategoricalMetaData(name, stateNames));
                } else {
                    meta.add(type.newColumnMetaData(name));
                }
                analysis.add(dataAnalysis);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Schema schema = new Schema(meta);
        return new DataAnalysis(schema, analysis);
    }

    private Map<String, List<Map<String, Object>>> getJsonRepresentation() {
        LinkedHashMap<String, List<Map<String, Object>>> jsonRepresentation = new LinkedHashMap<String, List<Map<String, Object>>>();
        ArrayList list = new ArrayList();
        jsonRepresentation.put(DATA_ANALYSIS, list);
        for (String colName : this.schema.getColumnNames()) {
            LinkedHashMap<String, Object> current = new LinkedHashMap<String, Object>();
            int idx = this.schema.getIndexOfColumn(colName);
            current.put(COL_NAME, colName);
            current.put(COL_IDX, idx);
            ColumnType columnType = this.schema.getMetaData(colName).getColumnType();
            current.put(COL_TYPE, (Object)columnType);
            if (columnType == ColumnType.Categorical) {
                current.put(CATEGORICAL_STATE_NAMES, ((CategoricalMetaData)this.schema.getMetaData(colName)).getStateNames());
            }
            current.put(ANALYSIS, Collections.singletonMap(this.columnAnalysis.get(idx).getClass().getSimpleName(), this.columnAnalysis.get(idx)));
            list.add(current);
        }
        return jsonRepresentation;
    }

    private String toJson(Map<String, List<Map<String, Object>>> jsonRepresentation) {
        ObjectMapper om = new JsonSerializer().getObjectMapper();
        try {
            return om.writeValueAsString(jsonRepresentation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String toYaml(Map<String, List<Map<String, Object>>> jsonRepresentation) {
        ObjectMapper om = new YamlSerializer().getObjectMapper();
        try {
            return om.writeValueAsString(jsonRepresentation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ConstructorProperties(value={"schema", "columnAnalysis"})
    public DataAnalysis(Schema schema, List<ColumnAnalysis> columnAnalysis) {
        this.schema = schema;
        this.columnAnalysis = columnAnalysis;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public List<ColumnAnalysis> getColumnAnalysis() {
        return this.columnAnalysis;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setColumnAnalysis(List<ColumnAnalysis> columnAnalysis) {
        this.columnAnalysis = columnAnalysis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataAnalysis)) {
            return false;
        }
        DataAnalysis other = (DataAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        List<ColumnAnalysis> this$columnAnalysis = this.getColumnAnalysis();
        List<ColumnAnalysis> other$columnAnalysis = other.getColumnAnalysis();
        return !(this$columnAnalysis == null ? other$columnAnalysis != null : !((Object)this$columnAnalysis).equals(other$columnAnalysis));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        List<ColumnAnalysis> $columnAnalysis = this.getColumnAnalysis();
        result = result * 59 + ($columnAnalysis == null ? 43 : ((Object)$columnAnalysis).hashCode());
        return result;
    }
}

