/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnIdx", "stateNames", "statesMap"})
public class CategoricalToIntegerTransform
extends BaseTransform {
    private String columnName;
    private int columnIdx = -1;
    private List<String> stateNames;
    private Map<String, Integer> statesMap;

    public CategoricalToIntegerTransform(@JsonProperty(value="columnName") String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        super.setInputSchema(inputSchema);
        this.columnIdx = inputSchema.getIndexOfColumn(this.columnName);
        ColumnMetaData meta = inputSchema.getMetaData(this.columnName);
        if (!(meta instanceof CategoricalMetaData)) {
            throw new IllegalStateException("Cannot convert column \"" + this.columnName + "\" from categorical to one-hot: column is not categorical (is: " + meta.getColumnType() + ")");
        }
        this.stateNames = ((CategoricalMetaData)meta).getStateNames();
        this.statesMap = new HashMap<String, Integer>(this.stateNames.size());
        for (int i = 0; i < this.stateNames.size(); ++i) {
            this.statesMap.put(this.stateNames.get(i), i);
        }
    }

    @Override
    public Schema transform(Schema schema) {
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        int i = 0;
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> typesIter = origMeta.iterator();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(schema.numColumns());
        while (namesIter.hasNext()) {
            String s = namesIter.next();
            ColumnMetaData t = typesIter.next();
            if (i++ == this.columnIdx) {
                int nClasses = this.stateNames.size();
                newMeta.add(new IntegerMetaData(t.getName(), 0, nClasses - 1));
                continue;
            }
            newMeta.add(t);
        }
        return schema.newSchema(newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int idx = this.getColumnIdx();
        int n = this.stateNames.size();
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == idx) {
                String str = w.toString();
                Integer classIdx = this.statesMap.get(str);
                if (classIdx == null) {
                    throw new IllegalStateException("Cannot convert categorical value to integer value: input value (\"" + str + "\") is not in the list of known categories (state names/categories: " + this.stateNames + ")");
                }
                out.add(new IntWritable(classIdx));
                continue;
            }
            out.add(w);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        String value = input.toString();
        Integer classIdx = this.statesMap.get(value);
        if (classIdx == null) {
            throw new IllegalStateException("Cannot convert categorical value to integer value: input value (\"" + value + "\") is not in the list of known categories (state names/categories: " + this.stateNames + ")");
        }
        return classIdx;
    }

    @Override
    public Object mapSequence(Object sequence) {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalToIntegerTransform)) {
            return false;
        }
        CategoricalToIntegerTransform o2 = (CategoricalToIntegerTransform)o;
        if (this.columnName == null) {
            return o2.columnName == null;
        }
        return this.columnName.equals(o2.columnName);
    }

    @Override
    public int hashCode() {
        return this.columnName.hashCode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CategoricalToIntegerTransform;
    }

    @Override
    public String outputColumnName() {
        return this.columnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.columnName()};
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName()};
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    public Map<String, Integer> getStatesMap() {
        return this.statesMap;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnIdx(int columnIdx) {
        this.columnIdx = columnIdx;
    }

    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    public void setStatesMap(Map<String, Integer> statesMap) {
        this.statesMap = statesMap;
    }

    @Override
    public String toString() {
        return "CategoricalToIntegerTransform(columnName=" + this.getColumnName() + ", columnIdx=" + this.getColumnIdx() + ", stateNames=" + this.getStateNames() + ", statesMap=" + this.getStatesMap() + ")";
    }
}

