/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.datavec.api.io.WritableComparable;
import org.datavec.api.io.WritableComparator;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.nd4j.shade.guava.math.DoubleMath;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FloatWritable
implements WritableComparable {
    private float value;

    public FloatWritable() {
    }

    public FloatWritable(@JsonProperty(value="value") float value) {
        this.set(value);
    }

    public void set(float value) {
        this.value = value;
    }

    public float get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readFloat();
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        out.writeShort(WritableType.Float.typeIdx());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.value);
    }

    public boolean fuzzyEquals(Writable o, double tolerance) {
        double other;
        if (o instanceof IntWritable) {
            other = ((IntWritable)o).toDouble();
        } else if (o instanceof LongWritable) {
            other = ((LongWritable)o).toDouble();
        } else if (o instanceof ByteWritable) {
            other = ((ByteWritable)o).toDouble();
        } else if (o instanceof DoubleWritable) {
            other = ((DoubleWritable)o).toDouble();
        } else if (o instanceof FloatWritable) {
            other = ((FloatWritable)o).toDouble();
        } else {
            return false;
        }
        return DoubleMath.fuzzyEquals((double)this.value, (double)other, (double)tolerance);
    }

    public boolean equals(Object o) {
        if (o instanceof FloatWritable) {
            FloatWritable other = (FloatWritable)o;
            return this.value == other.value;
        }
        if (o instanceof DoubleWritable) {
            DoubleWritable other = (DoubleWritable)o;
            float otherFloat = (float)other.get();
            return other.get() == (double)otherFloat && this.value == otherFloat;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int compareTo(Object o) {
        float thisValue = this.value;
        float thatValue = ((FloatWritable)o).value;
        return thisValue < thatValue ? -1 : (thisValue == thatValue ? 0 : 1);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return (long)this.value;
    }

    @Override
    public WritableType getType() {
        return WritableType.Float;
    }

    static {
        WritableComparator.define(FloatWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(FloatWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            float thatValue;
            float thisValue = Comparator.readFloat(b1, s1);
            return thisValue < (thatValue = Comparator.readFloat(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

