/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.codec.reader;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.datavec.api.conf.Configuration;
import org.datavec.api.util.ndarray.RecordConverter;
import org.datavec.api.writable.Writable;
import org.datavec.codec.reader.BaseCodecRecordReader;
import org.datavec.image.loader.ImageLoader;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.common.ByteBufferSeekableByteChannel;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.nd4j.linalg.api.ndarray.INDArray;

public class CodecRecordReader
extends BaseCodecRecordReader {
    private ImageLoader imageLoader;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.imageLoader = new ImageLoader(this.rows, this.cols);
    }

    @Override
    protected List<List<Writable>> loadData(File file, InputStream inputStream) throws IOException {
        Object seekableByteChannel;
        if (inputStream != null) {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            ByteBuffer bb = ByteBuffer.wrap(data);
            seekableByteChannel = new FixedByteBufferSeekableByteChannel(bb);
        } else {
            seekableByteChannel = NIOUtils.readableFileChannel((File)file);
        }
        ArrayList<List<Writable>> record = new ArrayList<List<Writable>>();
        if (this.numFrames >= 1) {
            FrameGrab fg;
            try {
                fg = new FrameGrab((SeekableByteChannel)seekableByteChannel);
                if (this.startFrame != 0) {
                    fg.seekToFramePrecise(this.startFrame);
                }
            }
            catch (JCodecException e) {
                throw new RuntimeException(e);
            }
            for (int i = this.startFrame; i < this.startFrame + this.numFrames; ++i) {
                try {
                    BufferedImage grab = fg.getFrame();
                    if (this.ravel) {
                        record.add(RecordConverter.toRecord((INDArray)this.imageLoader.toRaveledTensor(grab)));
                        continue;
                    }
                    record.add(RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(grab)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            if (this.framesPerSecond < 1.0) {
                throw new IllegalStateException("No frames or frame time intervals specified");
            }
            for (double i = 0.0; i < this.videoLength; i += this.framesPerSecond) {
                try {
                    BufferedImage grab = FrameGrab.getFrame((SeekableByteChannel)seekableByteChannel, (double)i);
                    if (this.ravel) {
                        record.add(RecordConverter.toRecord((INDArray)this.imageLoader.toRaveledTensor(grab)));
                        continue;
                    }
                    record.add(RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(grab)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return record;
    }

    private static class FixedByteBufferSeekableByteChannel
    extends ByteBufferSeekableByteChannel {
        private ByteBuffer backing;

        public FixedByteBufferSeekableByteChannel(ByteBuffer backing) {
            super(backing);
            try {
                Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("maxPos");
                f.setAccessible(true);
                f.set((Object)this, backing.limit());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.backing = backing;
        }

        public int read(ByteBuffer dst) throws IOException {
            if (!this.backing.hasRemaining()) {
                return -1;
            }
            return super.read(dst);
        }
    }
}

