/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.codec.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.api.conf.Configuration;
import org.datavec.api.util.ndarray.RecordConverter;
import org.datavec.api.writable.Writable;
import org.datavec.codec.reader.BaseCodecRecordReader;
import org.datavec.image.loader.NativeImageLoader;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NativeCodecRecordReader
extends BaseCodecRecordReader {
    private OpenCVFrameConverter.ToMat converter;
    private NativeImageLoader imageLoader;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.converter = new OpenCVFrameConverter.ToMat();
        this.imageLoader = new NativeImageLoader(this.rows, this.cols);
    }

    @Override
    protected List<List<Writable>> loadData(File file, InputStream inputStream) throws IOException {
        ArrayList<List<Writable>> record = new ArrayList<List<Writable>>();
        try (FFmpegFrameGrabber fg = inputStream != null ? new FFmpegFrameGrabber(inputStream) : new FFmpegFrameGrabber(file);){
            if (this.numFrames >= 1) {
                fg.start();
                if (this.startFrame != 0) {
                    fg.setFrameNumber(this.startFrame);
                }
                for (int i = this.startFrame; i < this.startFrame + this.numFrames; ++i) {
                    Frame grab = fg.grabImage();
                    record.add(RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(this.converter.convert(grab))));
                }
            } else {
                if (this.framesPerSecond < 1.0) {
                    throw new IllegalStateException("No frames or frame time intervals specified");
                }
                fg.start();
                for (double i = 0.0; i < this.videoLength; i += this.framesPerSecond) {
                    fg.setTimestamp(Math.round(i * 1000000.0));
                    Frame grab = fg.grabImage();
                    record.add(RecordConverter.toRecord((INDArray)this.imageLoader.asRowVector(this.converter.convert(grab))));
                }
            }
        }
        return record;
    }
}

