/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.datavec.image.loader.NativeImageLoader;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;

public class CifarLoader
extends NativeImageLoader
implements Serializable {
    public static final int NUM_TRAIN_IMAGES = 50000;
    public static final int NUM_TEST_IMAGES = 10000;
    public static final int NUM_LABELS = 10;
    public static final int HEIGHT = 32;
    public static final int WIDTH = 32;
    public static final int CHANNELS = 3;
    public static final int BYTEFILELEN = 3073;
    public String dataUrl = "https://www.cs.toronto.edu/~kriz/cifar-10-python.tar.gz";
    public String dataFile = "cifar-10-python";
    public static String dataBinUrl = "https://www.cs.toronto.edu/~kriz/cifar-10-binary.tar.gz";
    public static String dataBinFile = "cifar-10-batches-bin";
    protected static String labelFileName = "batches.meta.txt";
    protected List<String> labels = new ArrayList<String>();
    protected static String[] trainFileNames = new String[]{"data_batch_1.bin", "data_batch_2.bin", "data_batch_3.bin", "data_batch_4.bin", "data_batch5.bin"};
    protected static String testFileName = "test_batch.bin";
    public static String localDir = "cifar";
    protected static File fullDir = new File(BASE_DIR, localDir);
    protected boolean train = true;
    public static Map<String, String> cifarTrainData = new HashMap<String, String>();
    public static final File TRAINPATH = new File(fullDir, "train");
    public static final File TESTPATH = new File(fullDir, FilenameUtils.concat((String)dataBinFile, (String)testFileName));
    public static final File LABELPATH = new File(fullDir, FilenameUtils.concat((String)dataBinFile, (String)labelFileName));

    public CifarLoader(boolean train) {
        this.train = train;
    }

    public CifarLoader(int height, int width, int channels, boolean train) {
        super(height, width, channels);
        this.train = train;
    }

    public CifarLoader(int height, int width, int channels, ImageTransform imgTransform, int normalizeValue, boolean train) {
        super(height, width, channels, imgTransform, normalizeValue);
        this.train = train;
    }

    public CifarLoader(boolean train, String localDir) {
        CifarLoader.localDir = localDir;
        fullDir = new File(localDir);
        this.train = train;
        this.load();
    }

    public CifarLoader() {
        this.load();
    }

    public CifarLoader(int height, int width, int channels) {
        super(height, width, channels);
        this.load();
    }

    @Override
    public INDArray asRowVector(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asRowVector(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void generateMaps() {
        cifarTrainData.put("filesFilename", new File(dataBinUrl).getName());
        cifarTrainData.put("filesURL", dataBinUrl);
        cifarTrainData.put("filesFilenameUnzipped", dataBinFile);
    }

    private void defineLabels() {
        try {
            String line;
            File path = new File(fullDir, FilenameUtils.concat((String)dataBinFile, (String)labelFileName));
            BufferedReader br = new BufferedReader(new FileReader(path));
            while ((line = br.readLine()) != null) {
                this.labels.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        if (!this.imageFilesExist() && !fullDir.exists()) {
            this.generateMaps();
            fullDir.mkdir();
            log.info("Downloading {}...", (Object)localDir);
            this.downloadAndUntar(cifarTrainData, fullDir);
        }
        this.defineLabels();
    }

    public boolean imageFilesExist() {
        File f = new File(fullDir, FilenameUtils.concat((String)dataBinFile, (String)testFileName));
        if (!f.exists()) {
            return false;
        }
        for (String name : trainFileNames) {
            f = new File(fullDir, FilenameUtils.concat((String)dataBinFile, (String)name));
            if (f.exists()) continue;
            return false;
        }
        return true;
    }

    public InputStream getInputStream() {
        this.load();
        InputStream in = null;
        try {
            if (this.train) {
                Collection subFiles = FileUtils.listFiles((File)new File(fullDir, dataBinFile), (String[])new String[]{"bin"}, (boolean)true);
                Iterator trainIter = subFiles.iterator();
                in = new SequenceInputStream(new FileInputStream((File)trainIter.next()), new FileInputStream((File)trainIter.next()));
                while (trainIter.hasNext()) {
                    File nextFile = (File)trainIter.next();
                    if (testFileName.equals(nextFile.getName())) continue;
                    in = new SequenceInputStream(in, new FileInputStream(nextFile));
                }
            } else {
                in = new FileInputStream(new File(fullDir, FilenameUtils.concat((String)dataBinFile, (String)testFileName)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    public List<String> getLabels() {
        return this.labels;
    }
}

