/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;

public class ColorConversion
extends BaseImageTransform {
    int conversionCode;

    public ColorConversion() {
        this(new Random(1234L), 50);
    }

    public ColorConversion(Random random, int conversionCode) {
        super(random);
        this.conversionCode = conversionCode;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat result = new opencv_core.Mat();
        try {
            opencv_imgproc.cvtColor((opencv_core.Mat)mat, (opencv_core.Mat)result, (int)this.conversionCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

