/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.FFmpegFrameFilter;
import org.bytedeco.javacv.FrameFilter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"filter", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FilterImageTransform
extends BaseImageTransform {
    private FFmpegFrameFilter filter;
    private String filters;
    private int width;
    private int height;
    private int channels;

    public FilterImageTransform(String filters, int width, int height) {
        this(filters, width, height, 3);
    }

    public FilterImageTransform(@JsonProperty(value="filters") String filters, @JsonProperty(value="width") int width, @JsonProperty(value="height") int height, @JsonProperty(value="channels") int channels) {
        super(null);
        int pixelFormat;
        this.filters = filters;
        this.width = width;
        this.height = height;
        this.channels = channels;
        int n = channels == 1 ? 8 : (channels == 3 ? 3 : (pixelFormat = channels == 4 ? 28 : -1));
        if (pixelFormat == -1) {
            throw new IllegalArgumentException("Unsupported number of channels: " + channels);
        }
        try {
            this.filter = new FFmpegFrameFilter(filters, width, height);
            this.filter.setPixelFormat(pixelFormat);
            this.filter.start();
        }
        catch (FrameFilter.Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        try {
            this.filter.push(image.getFrame());
            image = new ImageWritable(this.filter.pull());
        }
        catch (FrameFilter.Exception e) {
            throw new RuntimeException(e);
        }
        return image;
    }
}

