/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"rng", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RandomCropTransform
extends BaseImageTransform<opencv_core.Mat> {
    protected int outputHeight;
    protected int outputWidth;
    protected Random rng;

    public RandomCropTransform(@JsonProperty(value="outputHeight") int height, @JsonProperty(value="outputWidth") int width) {
        this(1234L, height, width);
    }

    public RandomCropTransform(long seed, int height, int width) {
        this(null, seed, height, width);
    }

    public RandomCropTransform(java.util.Random random, long seed, int height, int width) {
        super(random);
        this.outputHeight = height;
        this.outputWidth = width;
        this.rng = Nd4j.getRandom();
        this.rng.setSeed(seed);
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, java.util.Random random) {
        if (image == null) {
            return null;
        }
        if (image.getFrame().imageHeight < this.outputHeight || image.getFrame().imageWidth < this.outputWidth) {
            throw new UnsupportedOperationException("Output height/width cannot be more than the input image. Requested: " + this.outputHeight + "+x" + this.outputWidth + ", got " + image.getFrame().imageHeight + "+x" + image.getFrame().imageWidth);
        }
        int cropTop = image.getFrame().imageHeight - this.outputHeight;
        int cropLeft = image.getFrame().imageWidth - this.outputWidth;
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        int top = this.rng.nextInt(cropTop + 1);
        int left = this.rng.nextInt(cropLeft + 1);
        int y = Math.min(top, mat.rows() - 1);
        int x = Math.min(left, mat.cols() - 1);
        opencv_core.Mat result = mat.apply(new opencv_core.Rect(x, y, this.outputWidth, this.outputHeight));
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

