/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVMLightRecordReader
extends LineRecordReader {
    private static Logger log = LoggerFactory.getLogger(SVMLightRecordReader.class);

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    public boolean hasNext() {
        return false;
    }

    public List<Writable> next() {
        Text t = (Text)super.next().iterator().next();
        String val = new String(t.getBytes());
        ArrayList<Writable> ret = new ArrayList<Writable>();
        try {
            int index;
            String col;
            int max = 0;
            StringTokenizer tok = new StringTokenizer(val, " \t");
            tok.nextToken();
            while (tok.hasMoreTokens() && !(col = tok.nextToken()).startsWith("#")) {
                if (col.startsWith("qid:") || (index = Integer.parseInt(col.substring(0, col.indexOf(":")))) <= max) continue;
                max = index;
            }
            tok = new StringTokenizer(val, " \t");
            double classVal = Double.parseDouble(tok.nextToken());
            while (tok.hasMoreTokens() && !(col = tok.nextToken()).startsWith("#")) {
                if (col.startsWith("qid:")) continue;
                index = Integer.parseInt(col.substring(0, col.indexOf(":")));
                double value = Double.parseDouble(col.substring(col.indexOf(":") + 1));
                ret.add((Writable)new DoubleWritable(value));
            }
            ret.add((Writable)new DoubleWritable(classVal));
        }
        catch (Exception e) {
            log.error("Error parsing line '" + val + "': ", (Throwable)e);
        }
        return ret;
    }
}

