/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.reader.mapfile;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.impl.Record;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataIndex;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.util.RandomUtils;
import org.datavec.api.writable.Writable;
import org.datavec.hadoop.records.reader.mapfile.IndexToKey;
import org.datavec.hadoop.records.reader.mapfile.MapFileReader;
import org.datavec.hadoop.records.reader.mapfile.index.LongIndexToKey;
import org.datavec.hadoop.records.reader.mapfile.record.RecordWritable;

public class MapFileRecordReader
implements RecordReader {
    private static final Class<? extends org.apache.hadoop.io.Writable> recordClass = RecordWritable.class;
    private final IndexToKey indexToKey;
    private MapFileReader<RecordWritable> mapFileReader;
    private URI baseDirUri;
    private List<RecordListener> listeners;
    private long numRecords;
    private long position;
    private Random rng;
    private int[] order;

    public MapFileRecordReader() throws Exception {
        this(new LongIndexToKey(), null);
    }

    public MapFileRecordReader(Random rng) {
        this(new LongIndexToKey(), rng);
    }

    public MapFileRecordReader(IndexToKey indexToKey, Random rng) {
        this.indexToKey = indexToKey;
        this.rng = rng;
    }

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.initialize(null, split);
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        URI[] uris = split.locations();
        int dataCount = 0;
        int indexCount = 0;
        ArrayList<URI> dataUris = new ArrayList<URI>();
        for (URI u : uris) {
            String p = u.getPath();
            if (p.endsWith("data")) {
                ++dataCount;
                dataUris.add(u);
                continue;
            }
            if (!p.endsWith("index")) continue;
            ++indexCount;
        }
        if (dataCount == 0 || indexCount == 0) {
            throw new IllegalStateException("Cannot initialize MapFileSequenceRecordReader: could not find data and index files in input split");
        }
        if (dataCount != indexCount) {
            throw new IllegalStateException("Invalid input: found " + dataCount + " data files but " + indexCount + " index files. Expect equal number of both for map files");
        }
        ArrayList<String> mapFilePartRootDirectories = new ArrayList<String>(dataUris.size());
        for (URI u : dataUris) {
            File partRootDir = new File(u).getParentFile();
            mapFilePartRootDirectories.add(partRootDir.getAbsolutePath());
        }
        Collections.sort(mapFilePartRootDirectories);
        this.baseDirUri = dataUris.size() == 1 ? new File((URI)dataUris.get(0)).getParentFile().toURI() : new File((URI)dataUris.get(0)).getParentFile().getParentFile().toURI();
        if (this.mapFileReader != null) {
            this.mapFileReader.close();
        }
        this.mapFileReader = new MapFileReader(mapFilePartRootDirectories, this.indexToKey, recordClass);
        this.numRecords = this.mapFileReader.numRecords();
        if (this.rng != null) {
            this.order = new int[(int)this.numRecords];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
            RandomUtils.shuffleInPlace((int[])this.order, (Random)this.rng);
        }
    }

    public void setConf(Configuration conf) {
    }

    public Configuration getConf() {
        return null;
    }

    public boolean batchesSupported() {
        return false;
    }

    public List<Writable> next(int num) {
        throw new UnsupportedOperationException();
    }

    public List<Writable> next() {
        return this.next(false).getRecord();
    }

    public boolean hasNext() {
        return this.position < this.numRecords;
    }

    public List<String> getLabels() {
        return null;
    }

    public void reset() {
        this.position = 0L;
        if (this.order != null) {
            RandomUtils.shuffleInPlace((int[])this.order, (Random)this.rng);
        }
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public org.datavec.api.records.Record nextRecord() {
        return this.next(true);
    }

    public org.datavec.api.records.Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<org.datavec.api.records.Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<RecordListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(RecordListener ... listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void setListeners(Collection<RecordListener> listeners) {
        this.listeners = new ArrayList<RecordListener>(listeners);
    }

    public void close() throws IOException {
        if (this.mapFileReader != null) {
            this.mapFileReader.close();
        }
    }

    private org.datavec.api.records.Record next(boolean withMetadata) {
        RecordWritable rec;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long currIdx = this.order != null ? (long)this.order[(int)this.position++] : this.position++;
        try {
            rec = this.mapFileReader.getRecord(currIdx);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RecordMetaDataIndex meta = withMetadata ? new RecordMetaDataIndex(currIdx, this.baseDirUri, MapFileRecordReader.class) : null;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (RecordListener l : this.listeners) {
                l.recordRead((RecordReader)this, (Object)rec);
            }
        }
        return new Record(rec.getRecord(), (RecordMetaData)meta);
    }
}

