/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.reader.mapfile.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;
import org.datavec.hadoop.records.reader.mapfile.IndexToKey;
import org.nd4j.linalg.primitives.Pair;

public class LongIndexToKey
implements IndexToKey {
    private List<Pair<Long, Long>> readerIndices;

    @Override
    public List<Pair<Long, Long>> initialize(MapFile.Reader[] readers, Class<? extends Writable> valueClass) throws IOException {
        ArrayList<Pair<Long, Long>> l = new ArrayList<Pair<Long, Long>>(readers.length);
        for (MapFile.Reader r : readers) {
            long first = -1L;
            long last = -1L;
            LongWritable k = new LongWritable();
            r.finalKey((WritableComparable)k);
            last = k.get();
            r.reset();
            Writable v = (Writable)ReflectionUtils.newInstance(valueClass, null);
            r.next((WritableComparable)k, v);
            first = k.get();
            l.add((Pair<Long, Long>)new Pair((Object)first, (Object)last));
        }
        ArrayList sorted = new ArrayList(l);
        Collections.sort(sorted, new Comparator<Pair<Long, Long>>(){

            @Override
            public int compare(Pair<Long, Long> o1, Pair<Long, Long> o2) {
                return Long.compare((Long)o1.getFirst(), (Long)o2.getFirst());
            }
        });
        if ((Long)((Pair)sorted.get(0)).getFirst() != 0L) {
            throw new UnsupportedOperationException("Minimum key value is not 0: got " + ((Pair)sorted.get(0)).getFirst());
        }
        for (int i = 0; i < sorted.size() - 1; ++i) {
            long nextFirst;
            long currLast = (Long)((Pair)sorted.get(i)).getSecond();
            if (currLast + 1L == (nextFirst = ((Long)((Pair)sorted.get(i + 1)).getFirst()).longValue())) continue;
            throw new IllegalStateException("Keys are not contiguous between readers: first/last indices (inclusive) are " + sorted + ".\n LongIndexKey assumes unique and contiguous LongWritable keys");
        }
        this.readerIndices = l;
        return this.readerIndices;
    }

    public LongWritable getKeyForIndex(long index) {
        return new LongWritable(index);
    }

    @Override
    public long getNumRecords() throws IOException {
        long max = -1L;
        for (Pair<Long, Long> p : this.readerIndices) {
            max = Math.max(max, (Long)p.getSecond());
        }
        if (max <= 0L) {
            throw new IllegalStateException("Invalid number of keys found: " + max);
        }
        return max + 1L;
    }
}

