/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.reader.mapfile.record;

import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.datavec.api.writable.WritableFactory;

public class SequenceRecordWritable
implements Writable {
    private List<List<org.datavec.api.writable.Writable>> sequenceRecord;

    public void write(DataOutput out) throws IOException {
        WritableFactory wf = WritableFactory.getInstance();
        out.writeInt(this.sequenceRecord.size());
        if (this.sequenceRecord.size() > 0) {
            int valuesPerStep = this.sequenceRecord.get(0).size();
            out.writeInt(valuesPerStep);
            for (List<org.datavec.api.writable.Writable> step : this.sequenceRecord) {
                if (step.size() != valuesPerStep) {
                    throw new IllegalStateException("Number of values per time step vary: " + valuesPerStep + " vs. " + step.size());
                }
                for (org.datavec.api.writable.Writable w : step) {
                    wf.writeWithType(w, out);
                }
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        WritableFactory wf = WritableFactory.getInstance();
        int numSteps = in.readInt();
        if (numSteps > 0) {
            int valuesPerStep = in.readInt();
            ArrayList<List<org.datavec.api.writable.Writable>> out = new ArrayList<List<org.datavec.api.writable.Writable>>(numSteps);
            for (int i = 0; i < numSteps; ++i) {
                ArrayList<org.datavec.api.writable.Writable> currStep = new ArrayList<org.datavec.api.writable.Writable>(valuesPerStep);
                for (int j = 0; j < valuesPerStep; ++j) {
                    currStep.add(wf.readWithType(in));
                }
                out.add(currStep);
            }
            this.sequenceRecord = out;
        } else {
            this.sequenceRecord = Collections.emptyList();
        }
    }

    @ConstructorProperties(value={"sequenceRecord"})
    public SequenceRecordWritable(List<List<org.datavec.api.writable.Writable>> sequenceRecord) {
        this.sequenceRecord = sequenceRecord;
    }

    public SequenceRecordWritable() {
    }

    public List<List<org.datavec.api.writable.Writable>> getSequenceRecord() {
        return this.sequenceRecord;
    }

    public void setSequenceRecord(List<List<org.datavec.api.writable.Writable>> sequenceRecord) {
        this.sequenceRecord = sequenceRecord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceRecordWritable)) {
            return false;
        }
        SequenceRecordWritable other = (SequenceRecordWritable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<org.datavec.api.writable.Writable>> this$sequenceRecord = this.getSequenceRecord();
        List<List<org.datavec.api.writable.Writable>> other$sequenceRecord = other.getSequenceRecord();
        return !(this$sequenceRecord == null ? other$sequenceRecord != null : !((Object)this$sequenceRecord).equals(other$sequenceRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceRecordWritable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<org.datavec.api.writable.Writable>> $sequenceRecord = this.getSequenceRecord();
        result = result * 59 + ($sequenceRecord == null ? 43 : ((Object)$sequenceRecord).hashCode());
        return result;
    }

    public String toString() {
        return "SequenceRecordWritable(sequenceRecord=" + this.getSequenceRecord() + ")";
    }
}

