/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.writer.mapfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.WritableComparable;
import org.datavec.api.conf.Configuration;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;

public abstract class AbstractMapFileWriter<T> {
    public static final String DEFAULT_FILENAME_PATTERN = "part-r-%1$05d";
    public static final Class<? extends WritableComparable> KEY_CLASS = LongWritable.class;
    public static final String MAP_FILE_INDEX_INTERVAL_KEY = "io.map.index.interval";
    public static final int DEFAULT_MAP_FILE_SPLIT_SIZE = -1;
    public static final int DEFAULT_INDEX_INTERVAL = 1;
    protected final File outputDir;
    protected final int mapFileSplitSize;
    protected final WritableType convertTextTo;
    protected final int indexInterval;
    protected final String filenamePattern;
    protected org.apache.hadoop.conf.Configuration hadoopConfiguration;
    protected final AtomicLong counter = new AtomicLong();
    protected final AtomicBoolean isClosed = new AtomicBoolean();
    protected List<File> outputFiles = new ArrayList<File>();
    protected List<MapFile.Writer> writers = new ArrayList<MapFile.Writer>();
    protected SequenceFile.Writer.Option[] opts;

    public AbstractMapFileWriter(File outputDir) {
        this(outputDir, -1);
    }

    public AbstractMapFileWriter(@NonNull File outputDir, int mapFileSplitSize) {
        this(outputDir, mapFileSplitSize, null);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public AbstractMapFileWriter(@NonNull File outputDir, WritableType convertTextTo) {
        this(outputDir, -1, convertTextTo);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public AbstractMapFileWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo) {
        this(outputDir, mapFileSplitSize, convertTextTo, 1, new org.apache.hadoop.conf.Configuration());
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public AbstractMapFileWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, int indexInterval, org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        this(outputDir, mapFileSplitSize, convertTextTo, indexInterval, DEFAULT_FILENAME_PATTERN, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public AbstractMapFileWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, int indexInterval, String filenamePattern, org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
        if (indexInterval <= 0) {
            throw new UnsupportedOperationException("Index interval: must be >= 0 (got: " + indexInterval + ")");
        }
        this.outputDir = outputDir;
        this.mapFileSplitSize = mapFileSplitSize;
        if (convertTextTo == WritableType.Text) {
            convertTextTo = null;
        }
        this.convertTextTo = convertTextTo;
        this.indexInterval = indexInterval;
        this.filenamePattern = filenamePattern;
        this.hadoopConfiguration = hadoopConfiguration;
        if (this.hadoopConfiguration.get(MAP_FILE_INDEX_INTERVAL_KEY) != null) {
            this.hadoopConfiguration.set(MAP_FILE_INDEX_INTERVAL_KEY, String.valueOf(indexInterval));
        }
        this.opts = new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(KEY_CLASS), SequenceFile.Writer.valueClass(this.getValueClass())};
    }

    protected abstract Class<? extends org.apache.hadoop.io.Writable> getValueClass();

    public void setConf(Configuration conf) {
    }

    public Configuration getConf() {
        return null;
    }

    protected abstract org.apache.hadoop.io.Writable getHadoopWritable(T var1);

    protected List<Writable> convertTextWritables(List<Writable> record) {
        List<Writable> newList;
        block11: {
            block8: {
                if (this.convertTextTo == null) break block8;
                newList = new ArrayList<Writable>(record.size());
                for (Writable writable : record) {
                    Writable newWritable;
                    block10: {
                        block9: {
                            if (writable.getType() != WritableType.Text) break block9;
                            switch (this.convertTextTo) {
                                case Byte: {
                                    newWritable = new ByteWritable((byte)writable.toInt());
                                    break block10;
                                }
                                case Double: {
                                    newWritable = new DoubleWritable(writable.toDouble());
                                    break block10;
                                }
                                case Float: {
                                    newWritable = new FloatWritable(writable.toFloat());
                                    break block10;
                                }
                                case Int: {
                                    newWritable = new IntWritable(writable.toInt());
                                    break block10;
                                }
                                case Long: {
                                    newWritable = new org.datavec.api.writable.LongWritable(writable.toLong());
                                    break block10;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Cannot convert text to: " + this.convertTextTo);
                                }
                            }
                        }
                        newWritable = writable;
                    }
                    newList.add(newWritable);
                }
                break block11;
            }
            newList = record;
        }
        return newList;
    }

    public void write(T record) throws IOException {
        MapFile.Writer w;
        if (this.isClosed.get()) {
            throw new UnsupportedOperationException("Cannot write to MapFileRecordReader that has already been closed");
        }
        if (this.counter.get() == 0L) {
            String filename = String.format(DEFAULT_FILENAME_PATTERN, 0);
            this.outputFiles.add(new File(this.outputDir, filename));
            this.writers.add(new MapFile.Writer(this.hadoopConfiguration, new Path(this.outputFiles.get(0).getAbsolutePath()), this.opts));
        }
        long key = this.counter.getAndIncrement();
        if (this.mapFileSplitSize <= 0) {
            w = this.writers.get(0);
        } else {
            int splitIdx = (int)(key / (long)this.mapFileSplitSize);
            if (this.writers.size() <= splitIdx) {
                String filename = String.format(DEFAULT_FILENAME_PATTERN, splitIdx);
                this.outputFiles.add(new File(this.outputDir, filename));
                this.writers.add(new MapFile.Writer(this.hadoopConfiguration, new Path(this.outputFiles.get(splitIdx).getAbsolutePath()), this.opts));
            }
            w = this.writers.get(splitIdx);
        }
        org.apache.hadoop.io.Writable hadoopWritable = this.getHadoopWritable(record);
        w.append((WritableComparable)new LongWritable(key), hadoopWritable);
    }

    public void close() {
        try {
            for (MapFile.Writer w : this.writers) {
                w.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.isClosed.set(true);
        }
    }
}

