/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.writer.mapfile;

import java.io.File;
import java.util.List;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.datavec.hadoop.records.reader.mapfile.record.RecordWritable;
import org.datavec.hadoop.records.writer.mapfile.AbstractMapFileWriter;

public class MapFileRecordWriter
extends AbstractMapFileWriter<List<Writable>>
implements RecordWriter {
    public MapFileRecordWriter(File outputDir) {
        super(outputDir);
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize) {
        this(outputDir, mapFileSplitSize, null);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, WritableType convertTextTo) {
        this(outputDir, -1, convertTextTo);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo) {
        super(outputDir, mapFileSplitSize, convertTextTo);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, Configuration hadoopConfiguration) {
        super(outputDir, mapFileSplitSize, convertTextTo, 1, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, int indexInterval, Configuration hadoopConfiguration) {
        super(outputDir, mapFileSplitSize, convertTextTo, indexInterval, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, int indexInterval, String filenamePattern, Configuration hadoopConfiguration) {
        super(outputDir, mapFileSplitSize, convertTextTo, indexInterval, filenamePattern, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir");
        }
    }

    @Override
    protected Class<? extends org.apache.hadoop.io.Writable> getValueClass() {
        return RecordWritable.class;
    }

    @Override
    protected org.apache.hadoop.io.Writable getHadoopWritable(List<Writable> input) {
        if (this.convertTextTo != null) {
            input = this.convertTextWritables(input);
        }
        return new RecordWritable(input);
    }
}

