/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.writable.Writable;
import org.datavec.common.data.NDArrayWritable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class RecordConverter {
    private RecordConverter() {
    }

    public static INDArray toArray(Collection<Writable> record, int size) {
        Iterator<Writable> writables = record.iterator();
        Writable firstWritable = writables.next();
        if (firstWritable instanceof NDArrayWritable) {
            NDArrayWritable ret = (NDArrayWritable)firstWritable;
            return ret.get();
        }
        INDArray vector = Nd4j.create((int)size);
        vector.putScalar(0, firstWritable.toDouble());
        int count = 1;
        while (writables.hasNext()) {
            Writable w = writables.next();
            vector.putScalar(count++, w.toDouble());
        }
        return vector;
    }

    public static List<List<Writable>> toRecords(INDArray matrix) {
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        for (int i = 0; i < matrix.rows(); ++i) {
            ret.add(RecordConverter.toRecord(matrix.getRow(i)));
        }
        return ret;
    }

    public static INDArray toMatrix(List<List<Writable>> records) {
        INDArray arr = Nd4j.create((int)records.size(), (int)records.get(0).size());
        for (int i = 0; i < arr.rows(); ++i) {
            arr.putRow(i, RecordConverter.toArray((Collection<Writable>)records.get(i)));
        }
        return arr;
    }

    public static INDArray toArray(Collection<Writable> record) {
        return RecordConverter.toArray(record, record.size());
    }

    public static List<Writable> toRecord(INDArray array) {
        ArrayList<Writable> writables = new ArrayList<Writable>();
        writables.add((Writable)new NDArrayWritable(array));
        return writables;
    }
}

