/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.histogram;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.histogram.HistogramCounter;

public class CategoricalHistogramCounter
implements HistogramCounter {
    private HashMap<String, Integer> counts = new HashMap();
    private List<String> stateNames;

    public CategoricalHistogramCounter(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    @Override
    public HistogramCounter add(Writable w) {
        String value = w.toString();
        if (this.counts.containsKey(value)) {
            this.counts.put(value, this.counts.get(value) + 1);
        } else {
            this.counts.put(value, 1);
        }
        return this;
    }

    @Override
    public HistogramCounter merge(HistogramCounter other) {
        if (!(other instanceof CategoricalHistogramCounter)) {
            throw new IllegalArgumentException("Input must be CategoricalHistogramCounter; got " + other);
        }
        CategoricalHistogramCounter o = (CategoricalHistogramCounter)other;
        for (Map.Entry<String, Integer> entry : o.counts.entrySet()) {
            String key = entry.getKey();
            if (this.counts.containsKey(key)) {
                this.counts.put(key, this.counts.get(key) + entry.getValue());
                continue;
            }
            this.counts.put(key, entry.getValue());
        }
        return this;
    }

    @Override
    public double[] getBins() {
        double[] bins = new double[this.stateNames.size() + 1];
        for (int i = 0; i < bins.length; ++i) {
            bins[i] = i;
        }
        return bins;
    }

    @Override
    public long[] getCounts() {
        long[] ret = new long[this.stateNames.size()];
        int i = 0;
        for (String s : this.stateNames) {
            ret[i++] = this.counts.containsKey(s) ? (long)this.counts.get(s).intValue() : 0L;
        }
        return ret;
    }
}

