/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.string;

import java.beans.ConstructorProperties;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.AnalysisCounter;

public class StringAnalysisCounter
implements AnalysisCounter<StringAnalysisCounter> {
    private long countZeroLength;
    private long countMinLength;
    private int minLengthSeen = Integer.MAX_VALUE;
    private long countMaxLength;
    private int maxLengthSeen = Integer.MIN_VALUE;
    private long sumLength = 0L;
    private long countTotal = 0L;

    public StringAnalysisCounter() {
    }

    @Override
    public StringAnalysisCounter add(Writable writable) {
        int length = writable.toString().length();
        if (length == 0) {
            ++this.countZeroLength;
        }
        if (length == this.minLengthSeen) {
            ++this.countMinLength;
        } else if (length < this.minLengthSeen) {
            this.minLengthSeen = length;
            this.countMinLength = 1L;
        }
        if (length == this.maxLengthSeen) {
            ++this.countMaxLength;
        } else if (length > this.maxLengthSeen) {
            this.maxLengthSeen = length;
            this.countMaxLength = 1L;
        }
        this.sumLength += (long)length;
        ++this.countTotal;
        return this;
    }

    @Override
    public StringAnalysisCounter merge(StringAnalysisCounter other) {
        long newCountMaxLength;
        int newMaxLengthSeen;
        long newCountMinLength;
        int newMinLengthSeen;
        int otherMin = other.getMinLengthSeen();
        if (this.minLengthSeen == otherMin) {
            newMinLengthSeen = this.minLengthSeen;
            newCountMinLength = this.countMinLength + other.countMinLength;
        } else if (this.minLengthSeen > otherMin) {
            newMinLengthSeen = otherMin;
            newCountMinLength = other.countMinLength;
        } else {
            newMinLengthSeen = this.minLengthSeen;
            newCountMinLength = this.countMinLength;
        }
        int otherMax = other.getMaxLengthSeen();
        if (this.maxLengthSeen == otherMax) {
            newMaxLengthSeen = this.maxLengthSeen;
            newCountMaxLength = this.countMaxLength + other.countMaxLength;
        } else if (this.maxLengthSeen < otherMax) {
            newMaxLengthSeen = otherMax;
            newCountMaxLength = other.countMaxLength;
        } else {
            newMaxLengthSeen = this.maxLengthSeen;
            newCountMaxLength = this.countMaxLength;
        }
        return new StringAnalysisCounter(this.countZeroLength + other.countZeroLength, newCountMinLength, newMinLengthSeen, newCountMaxLength, newMaxLengthSeen, this.sumLength + other.sumLength, this.countTotal + other.countTotal);
    }

    @ConstructorProperties(value={"countZeroLength", "countMinLength", "minLengthSeen", "countMaxLength", "maxLengthSeen", "sumLength", "countTotal"})
    public StringAnalysisCounter(long countZeroLength, long countMinLength, int minLengthSeen, long countMaxLength, int maxLengthSeen, long sumLength, long countTotal) {
        this.countZeroLength = countZeroLength;
        this.countMinLength = countMinLength;
        this.minLengthSeen = minLengthSeen;
        this.countMaxLength = countMaxLength;
        this.maxLengthSeen = maxLengthSeen;
        this.sumLength = sumLength;
        this.countTotal = countTotal;
    }

    public long getCountZeroLength() {
        return this.countZeroLength;
    }

    public long getCountMinLength() {
        return this.countMinLength;
    }

    public int getMinLengthSeen() {
        return this.minLengthSeen;
    }

    public long getCountMaxLength() {
        return this.countMaxLength;
    }

    public int getMaxLengthSeen() {
        return this.maxLengthSeen;
    }

    public long getSumLength() {
        return this.sumLength;
    }

    public long getCountTotal() {
        return this.countTotal;
    }

    public void setCountZeroLength(long countZeroLength) {
        this.countZeroLength = countZeroLength;
    }

    public void setCountMinLength(long countMinLength) {
        this.countMinLength = countMinLength;
    }

    public void setMinLengthSeen(int minLengthSeen) {
        this.minLengthSeen = minLengthSeen;
    }

    public void setCountMaxLength(long countMaxLength) {
        this.countMaxLength = countMaxLength;
    }

    public void setMaxLengthSeen(int maxLengthSeen) {
        this.maxLengthSeen = maxLengthSeen;
    }

    public void setSumLength(long sumLength) {
        this.sumLength = sumLength;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringAnalysisCounter)) {
            return false;
        }
        StringAnalysisCounter other = (StringAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCountZeroLength() != other.getCountZeroLength()) {
            return false;
        }
        if (this.getCountMinLength() != other.getCountMinLength()) {
            return false;
        }
        if (this.getMinLengthSeen() != other.getMinLengthSeen()) {
            return false;
        }
        if (this.getCountMaxLength() != other.getCountMaxLength()) {
            return false;
        }
        if (this.getMaxLengthSeen() != other.getMaxLengthSeen()) {
            return false;
        }
        if (this.getSumLength() != other.getSumLength()) {
            return false;
        }
        return this.getCountTotal() == other.getCountTotal();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $countZeroLength = this.getCountZeroLength();
        result = result * 59 + (int)($countZeroLength >>> 32 ^ $countZeroLength);
        long $countMinLength = this.getCountMinLength();
        result = result * 59 + (int)($countMinLength >>> 32 ^ $countMinLength);
        result = result * 59 + this.getMinLengthSeen();
        long $countMaxLength = this.getCountMaxLength();
        result = result * 59 + (int)($countMaxLength >>> 32 ^ $countMaxLength);
        result = result * 59 + this.getMaxLengthSeen();
        long $sumLength = this.getSumLength();
        result = result * 59 + (int)($sumLength >>> 32 ^ $sumLength);
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        return result;
    }

    public String toString() {
        return "StringAnalysisCounter(countZeroLength=" + this.getCountZeroLength() + ", countMinLength=" + this.getCountMinLength() + ", minLengthSeen=" + this.getMinLengthSeen() + ", countMaxLength=" + this.getCountMaxLength() + ", maxLengthSeen=" + this.getMaxLengthSeen() + ", sumLength=" + this.getSumLength() + ", countTotal=" + this.getCountTotal() + ")";
    }
}

