/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.join;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.spark.api.java.function.PairFunction;
import org.datavec.api.transform.join.Join;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.join.JoinValue;
import scala.Tuple2;

public class MapToJoinValuesFunction
implements PairFunction<List<Writable>, List<Writable>, JoinValue> {
    private boolean left;
    private Join join;

    public Tuple2<List<Writable>, JoinValue> call(List<Writable> writables) throws Exception {
        List<Object> keyValues;
        String[] keyColumns;
        Schema schema;
        if (this.left) {
            schema = this.join.getLeftSchema();
            keyColumns = this.join.getJoinColumnsLeft();
        } else {
            schema = this.join.getRightSchema();
            keyColumns = this.join.getJoinColumnsRight();
        }
        if (keyColumns.length == 1) {
            keyValues = Collections.singletonList(writables.get(schema.getIndexOfColumn(keyColumns[0])));
        } else {
            keyValues = new ArrayList(keyColumns.length);
            for (String s : keyColumns) {
                keyValues.add(writables.get(schema.getIndexOfColumn(s)));
            }
        }
        return new Tuple2(keyValues, (Object)new JoinValue(this.left, writables));
    }

    @ConstructorProperties(value={"left", "join"})
    public MapToJoinValuesFunction(boolean left, Join join) {
        this.left = left;
        this.join = join;
    }
}

