/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.quality.categorical;

import java.beans.ConstructorProperties;
import org.apache.spark.api.java.function.Function2;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.quality.columns.CategoricalQuality;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class CategoricalQualityAddFunction
implements Function2<CategoricalQuality, Writable, CategoricalQuality> {
    private final CategoricalMetaData meta;

    public CategoricalQuality call(CategoricalQuality v1, Writable writable) throws Exception {
        long valid = v1.getCountValid();
        long invalid = v1.getCountInvalid();
        long countMissing = v1.getCountMissing();
        long countTotal = v1.getCountTotal() + 1L;
        if (this.meta.isValid(writable)) {
            ++valid;
        } else if (writable instanceof NullWritable || writable instanceof Text && (writable.toString() == null || writable.toString().isEmpty())) {
            ++countMissing;
        } else {
            ++invalid;
        }
        return new CategoricalQuality(valid, invalid, countMissing, countTotal);
    }

    @ConstructorProperties(value={"meta"})
    public CategoricalQualityAddFunction(CategoricalMetaData meta) {
        this.meta = meta;
    }
}

