/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.sparkfunction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.DataFrames;

public class SequenceToRows
implements FlatMapFunction<List<List<Writable>>, Row> {
    private Schema schema;
    private StructType structType;

    public SequenceToRows(Schema schema) {
        this.schema = schema;
        this.structType = DataFrames.fromSchemaSequence(schema);
    }

    public Iterable<Row> call(List<List<Writable>> sequence) throws Exception {
        if (sequence.size() == 0) {
            return Collections.emptyList();
        }
        String sequenceUUID = UUID.randomUUID().toString();
        ArrayList<Row> out = new ArrayList<Row>(sequence.size());
        int stepCount = 0;
        for (List<Writable> step : sequence) {
            Object[] values = new Object[step.size() + 2];
            values[0] = sequenceUUID;
            values[1] = stepCount++;
            block7: for (int i = 0; i < step.size(); ++i) {
                switch ((ColumnType)this.schema.getColumnTypes().get(i)) {
                    case Double: {
                        values[i + 2] = step.get(i).toDouble();
                        continue block7;
                    }
                    case Integer: {
                        values[i + 2] = step.get(i).toInt();
                        continue block7;
                    }
                    case Long: {
                        values[i + 2] = step.get(i).toLong();
                        continue block7;
                    }
                    case Float: {
                        values[i + 2] = Float.valueOf(step.get(i).toFloat());
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("This api should not be used with strings , binary data or ndarrays. This is only for columnar data");
                    }
                }
            }
            GenericRowWithSchema row = new GenericRowWithSchema(values, this.structType);
            out.add((Row)row);
        }
        return out;
    }
}

