/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.sparkfunction;

import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.common.data.NDArrayWritable;
import org.datavec.spark.transform.DataFrames;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ToRow
implements Function<List<Writable>, Row> {
    private Schema schema;
    private StructType structType;

    public ToRow(Schema schema) {
        this.schema = schema;
        this.structType = DataFrames.fromSchema(schema);
    }

    public Row call(List<Writable> v1) throws Exception {
        if (v1.size() == 1 && v1.get(0) instanceof NDArrayWritable) {
            NDArrayWritable writable = (NDArrayWritable)v1.get(0);
            INDArray arr = writable.get();
            if (arr.columns() != this.schema.numColumns()) {
                throw new IllegalStateException("Illegal record of size " + v1 + ". Should have been " + this.schema.numColumns());
            }
            Object[] values = new Object[arr.columns()];
            block12: for (int i = 0; i < values.length; ++i) {
                switch ((ColumnType)this.schema.getColumnTypes().get(i)) {
                    case Double: {
                        values[i] = arr.getDouble(i);
                        continue block12;
                    }
                    case Integer: {
                        values[i] = (int)arr.getDouble(i);
                        continue block12;
                    }
                    case Long: {
                        values[i] = (long)arr.getDouble(i);
                        continue block12;
                    }
                    case Float: {
                        values[i] = Float.valueOf((float)arr.getDouble(i));
                        continue block12;
                    }
                    default: {
                        throw new IllegalStateException("This api should not be used with strings , binary data or ndarrays. This is only for columnar data");
                    }
                }
            }
            GenericRowWithSchema row = new GenericRowWithSchema(values, this.structType);
            return row;
        }
        if (v1.size() != this.schema.numColumns()) {
            throw new IllegalStateException("Illegal record of size " + v1 + ". Should have been " + this.schema.numColumns());
        }
        Object[] values = new Object[v1.size()];
        block13: for (int i = 0; i < values.length; ++i) {
            switch ((ColumnType)this.schema.getColumnTypes().get(i)) {
                case Double: {
                    values[i] = v1.get(i).toDouble();
                    continue block13;
                }
                case Integer: {
                    values[i] = v1.get(i).toInt();
                    continue block13;
                }
                case Long: {
                    values[i] = v1.get(i).toLong();
                    continue block13;
                }
                case Float: {
                    values[i] = Float.valueOf(v1.get(i).toFloat());
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("This api should not be used with strings , binary data or ndarrays. This is only for columnar data");
                }
            }
        }
        GenericRowWithSchema row = new GenericRowWithSchema(values, this.structType);
        return row;
    }
}

