/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.columns;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.analysis.AnalysisCounter;

public class CategoricalAnalysisCounter
implements AnalysisCounter<CategoricalAnalysisCounter> {
    private Map<String, Long> counts = new HashMap<String, Long>();
    private long countTotal = 0L;

    public CategoricalAnalysisCounter() {
    }

    @Override
    public CategoricalAnalysisCounter add(Writable writable) {
        String value = writable.toString();
        long newCount = 0L;
        if (this.counts.containsKey(value)) {
            newCount = this.counts.get(value);
        }
        this.counts.put(value, ++newCount);
        ++this.countTotal;
        return this;
    }

    @Override
    public CategoricalAnalysisCounter merge(CategoricalAnalysisCounter other) {
        HashSet<String> combinedKeySet = new HashSet<String>(this.counts.keySet());
        combinedKeySet.addAll(other.counts.keySet());
        for (String s : combinedKeySet) {
            long count = 0L;
            if (this.counts.containsKey(s)) {
                count += this.counts.get(s).longValue();
            }
            if (other.counts.containsKey(s)) {
                count += other.counts.get(s).longValue();
            }
            this.counts.put(s, count);
        }
        this.countTotal += other.countTotal;
        return this;
    }

    @ConstructorProperties(value={"counts", "countTotal"})
    public CategoricalAnalysisCounter(Map<String, Long> counts, long countTotal) {
        this.counts = counts;
        this.countTotal = countTotal;
    }

    public Map<String, Long> getCounts() {
        return this.counts;
    }

    public long getCountTotal() {
        return this.countTotal;
    }

    public void setCounts(Map<String, Long> counts) {
        this.counts = counts;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalAnalysisCounter)) {
            return false;
        }
        CategoricalAnalysisCounter other = (CategoricalAnalysisCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Long> this$counts = this.getCounts();
        Map<String, Long> other$counts = other.getCounts();
        if (this$counts == null ? other$counts != null : !((Object)this$counts).equals(other$counts)) {
            return false;
        }
        return this.getCountTotal() == other.getCountTotal();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoricalAnalysisCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Long> $counts = this.getCounts();
        result = result * 59 + ($counts == null ? 43 : ((Object)$counts).hashCode());
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        return result;
    }

    public String toString() {
        return "CategoricalAnalysisCounter(counts=" + this.getCounts() + ", countTotal=" + this.getCountTotal() + ")";
    }
}

