/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.analysis.seqlength;

import org.apache.spark.api.java.function.Function2;
import org.datavec.spark.transform.analysis.seqlength.SequenceLengthAnalysisCounter;

public class SequenceLengthAnalysisAddFunction
implements Function2<SequenceLengthAnalysisCounter, Integer, SequenceLengthAnalysisCounter> {
    public SequenceLengthAnalysisCounter call(SequenceLengthAnalysisCounter v1, Integer length) throws Exception {
        int newMaxValue;
        int newMinValue;
        long zero = v1.getCountZeroLength();
        long one = v1.getCountOneLength();
        if (length == 0) {
            ++zero;
        } else if (length == 1) {
            ++one;
        }
        long countMinValue = v1.getCountMinLength();
        if (length.intValue() == v1.getMinLengthSeen()) {
            newMinValue = length;
            ++countMinValue;
        } else if (v1.getMinLengthSeen() > length) {
            newMinValue = length;
            countMinValue = 1L;
        } else {
            newMinValue = v1.getMinLengthSeen();
        }
        long countMaxValue = v1.getCountMaxLength();
        if (length.intValue() == v1.getMaxLengthSeen()) {
            newMaxValue = length;
            ++countMaxValue;
        } else if (v1.getMaxLengthSeen() < length) {
            newMaxValue = length;
            countMaxValue = 1L;
        } else {
            newMaxValue = v1.getMaxLengthSeen();
        }
        double sum = v1.getMean() * (double)v1.getCountTotal() + (double)length.intValue();
        long newTotalCount = v1.getCountTotal() + 1L;
        double newMean = sum / (double)newTotalCount;
        return new SequenceLengthAnalysisCounter(zero, one, countMinValue, newMinValue, countMaxValue, newMaxValue, newTotalCount, newMean);
    }
}

