/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.join;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datavec.api.transform.join.Join;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.join.JoinedValue;

public class FilterAndFlattenJoinedValues
implements FlatMapFunction<JoinedValue, List<Writable>> {
    private final Join.JoinType joinType;

    public Iterable<List<Writable>> call(JoinedValue joinedValue) throws Exception {
        boolean keep;
        switch (this.joinType) {
            case Inner: {
                keep = joinedValue.isHaveLeft() && joinedValue.isHaveRight();
                break;
            }
            case LeftOuter: {
                keep = joinedValue.isHaveLeft();
                break;
            }
            case RightOuter: {
                keep = joinedValue.isHaveRight();
                break;
            }
            case FullOuter: {
                keep = true;
                break;
            }
            default: {
                throw new RuntimeException("Unknown/not implemented join type: " + this.joinType);
            }
        }
        if (keep) {
            return Collections.singletonList(joinedValue.getValues());
        }
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"joinType"})
    public FilterAndFlattenJoinedValues(Join.JoinType joinType) {
        this.joinType = joinType;
    }
}

