/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.transform;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.function.Function;
import org.datavec.api.transform.Transform;
import org.datavec.api.writable.Writable;
import org.datavec.spark.transform.SparkTransformExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkTransformFunction
implements Function<List<Writable>, List<Writable>> {
    private static final Logger log = LoggerFactory.getLogger(SparkTransformFunction.class);
    private final Transform transform;

    public List<Writable> call(List<Writable> v1) throws Exception {
        if (SparkTransformExecutor.isTryCatch()) {
            try {
                return this.transform.map(v1);
            }
            catch (Exception e) {
                log.warn("Error occurred " + e + " on record " + v1);
                return new ArrayList<Writable>();
            }
        }
        return this.transform.map(v1);
    }

    @ConstructorProperties(value={"transform"})
    public SparkTransformFunction(Transform transform) {
        this.transform = transform;
    }
}

