/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;

public class DeepBoofDataBaseOps {
    public static File downloadModel(List<String> addresses, File destination) {
        if (addresses.size() == 0) {
            return null;
        }
        if (!destination.exists() && !destination.mkdirs()) {
            throw new RuntimeException("Can't create destination directories");
        }
        String fileName = new File(addresses.get(0)).getName();
        File pathDirectory = new File(destination, fileName.substring(0, fileName.length() - 4));
        if (pathDirectory.exists()) {
            return pathDirectory;
        }
        int which = DeepBoofDataBaseOps.download(addresses, new File(destination, fileName));
        if (which >= 0) {
            DeepBoofDataBaseOps.decompressZip(new File(destination, fileName), destination, true);
            return pathDirectory;
        }
        throw new RuntimeException("Failed to download model");
    }

    public static File downloadModel(String address, File destination) {
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add(address);
        return DeepBoofDataBaseOps.downloadModel(addresses, destination);
    }

    public static int download(List<String> urls, File output) {
        for (int i = 0; i < urls.size(); ++i) {
            String location = urls.get(i);
            try {
                DeepBoofDataBaseOps.download(location, output);
                return i;
            }
            catch (IOException o) {
                System.err.println("Failed because of " + o.getClass().getSimpleName());
                System.err.println(o.getMessage());
                System.err.println();
                continue;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String location, File output) throws IOException {
        int maxTicks;
        long downloadedBytes;
        long remoteFileSize;
        block17: {
            URL url = new URL(location);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(1000);
            connection.connect();
            remoteFileSize = connection.getContentLengthLong();
            System.out.println("Content length = " + remoteFileSize / 1024L / 1024L + " MB");
            if (output.exists()) {
                if (remoteFileSize > 0L && output.length() != remoteFileSize) {
                    System.out.println("File exists, but is not the expected size.  found " + output.length() + " expected " + remoteFileSize);
                    if (!output.delete()) {
                        throw new IOException("Failed to delete corrupted file");
                    }
                } else {
                    System.out.println("file already downloaded");
                    return;
                }
            }
            InputStream is = connection.getInputStream();
            FileOutputStream fos = new FileOutputStream(output);
            byte[] buffer = new byte[102400];
            downloadedBytes = 0L;
            int ticks = 0;
            maxTicks = 60;
            System.out.println("Downloading: " + url);
            if (remoteFileSize > 0L) {
                System.out.print("|");
                for (int i = 1; i < maxTicks; ++i) {
                    System.out.print("-");
                }
                System.out.println("|");
            } else {
                System.out.println("   unknown remote file size");
            }
            try {
                while (downloadedBytes < remoteFileSize) {
                    while (is.available() > 0) {
                        int amount = Math.min(buffer.length, is.available());
                        int ret = is.read(buffer, 0, amount);
                        if (ret <= 0) {
                            break block17;
                        }
                        downloadedBytes += (long)ret;
                        fos.write(buffer, 0, ret);
                        if (remoteFileSize <= 0L) continue;
                        int updatedTicks = (int)((long)maxTicks * downloadedBytes / remoteFileSize);
                        for (int i = ticks; i < updatedTicks; ++i) {
                            System.out.print("*");
                        }
                        ticks = updatedTicks;
                    }
                }
            }
            finally {
                is.close();
                fos.flush();
                fos.close();
            }
        }
        if (remoteFileSize > 0L) {
            int updatedTicks = (int)((long)maxTicks * downloadedBytes / remoteFileSize);
            for (int i = ticks; i < updatedTicks; ++i) {
                System.out.print("*");
            }
            System.out.println();
        }
        if (remoteFileSize > 0L && downloadedBytes != remoteFileSize) {
            throw new IOException("Didn't download the entire file.  fraction = " + (double)downloadedBytes / (double)remoteFileSize);
        }
    }

    public static void decompressTGZ(File src, File dst) {
        Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
        try {
            archiver.extract(src, dst);
        }
        catch (IOException e) {
            System.out.println("Failed to decompress.  " + e.getMessage());
            System.exit(1);
        }
    }

    public static void decompressZip(File src, File dst, boolean deleteZip) {
        try {
            ZipFile zipFile = new ZipFile(src);
            zipFile.extractAll(dst.getAbsolutePath());
            if (deleteZip && !src.delete()) {
                System.err.println("Failed to delete " + src.getName());
            }
        }
        catch (ZipException e) {
            System.err.println("Failed to decompress.  " + e.getMessage());
            System.exit(1);
        }
    }

    public static void moveInsideAndDeleteDir(File srcDir, File dstDir) {
        if (!srcDir.isDirectory()) {
            System.out.println(srcDir.getName() + " isn't a directory");
            System.exit(1);
        }
        if (!dstDir.isDirectory()) {
            System.out.println(dstDir.getName() + " isn't a directory");
            System.exit(1);
        }
        for (File f : srcDir.listFiles()) {
            try {
                Files.move(f.toPath(), new File(dstDir, f.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                System.out.println("Failed to move.  " + e.getMessage());
                System.exit(1);
            }
        }
        if (!srcDir.delete()) {
            System.err.println("Failed to cleanup " + srcDir.getName());
        }
    }
}

