/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7;

import deepboof.io.torch7.TorchType;
import deepboof.io.torch7.struct.TorchBoolean;
import deepboof.io.torch7.struct.TorchByteStorage;
import deepboof.io.torch7.struct.TorchCharStorage;
import deepboof.io.torch7.struct.TorchDoubleStorage;
import deepboof.io.torch7.struct.TorchFloatStorage;
import deepboof.io.torch7.struct.TorchGeneric;
import deepboof.io.torch7.struct.TorchList;
import deepboof.io.torch7.struct.TorchNumber;
import deepboof.io.torch7.struct.TorchObject;
import deepboof.io.torch7.struct.TorchReferenceable;
import deepboof.io.torch7.struct.TorchStorage;
import deepboof.io.torch7.struct.TorchString;
import deepboof.io.torch7.struct.TorchTensor;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class SerializeTorch7 {
    OutputStream stream;
    DataOutput output;
    protected boolean verbose = false;
    protected List<TorchObject> savedObjects = new ArrayList<TorchObject>();

    public void serialize(TorchObject object, OutputStream stream) throws IOException {
        ArrayList<TorchObject> objects = new ArrayList<TorchObject>();
        objects.add(object);
        this.serialize(objects, stream);
    }

    public void serialize(List<TorchObject> objects, OutputStream stream) throws IOException {
        this.stream = stream;
        this.output = new DataOutputStream(stream);
        this.savedObjects.clear();
        for (int i = 0; i < objects.size(); ++i) {
            this.serializeObject(objects.get(i));
        }
    }

    protected void serializeObject(TorchObject object) throws IOException {
        if (object instanceof TorchGeneric) {
            TorchGeneric g = (TorchGeneric)object;
            if (g.torchName == null) {
                this.writeType(TorchType.TABLE);
                this.serializeTable(g);
            } else {
                this.writeType(TorchType.TORCH);
                if (this.savedObjects.contains(object)) {
                    this.writeS32(this.savedObjects.indexOf(object) + 1);
                } else {
                    this.writeS32(this.savedObjects.size() + 1);
                    this.savedObjects.add(object);
                    this.writeString("V " + g.version);
                    this.writeString(g.torchName);
                    if (g.map != null) {
                        this.serializeTable(g);
                    }
                }
            }
        } else if (object instanceof TorchString) {
            this.writeType(TorchType.STRING);
            this.writeString(((TorchString)object).message);
        } else if (object instanceof TorchNumber) {
            this.writeType(TorchType.NUMBER);
            this.writeDouble(((TorchNumber)object).value);
        } else if (object instanceof TorchBoolean) {
            this.writeType(TorchType.BOOLEAN);
            this.writeBoolean(((TorchBoolean)object).value);
        } else if (object instanceof TorchList) {
            this.writeType(TorchType.TABLE);
            this.serializeList((TorchList)object);
        } else {
            TorchReferenceable r = (TorchReferenceable)object;
            this.writeType(TorchType.TORCH);
            if (this.savedObjects.contains(object)) {
                this.writeS32(this.savedObjects.indexOf(object) + 1);
            } else {
                this.writeS32(this.savedObjects.size() + 1);
                this.savedObjects.add(object);
                this.writeString("V " + r.version);
                this.writeString(r.torchName);
                if (object instanceof TorchTensor) {
                    this.serializeTensor((TorchTensor)object);
                    return;
                }
                if (object instanceof TorchStorage) {
                    this.serializeStorage((TorchStorage)object);
                    return;
                }
            }
            throw new RuntimeException("Support this type " + object.getClass().getSimpleName());
        }
    }

    protected void serializeStorage(TorchStorage storage) throws IOException {
        switch (storage.torchName) {
            case "torch.LongStorage": {
                throw new IOException("LongStorage not yet supported");
            }
            case "torch.FloatStorage": {
                this.writeS64(storage.size());
                this.writeArrayFloat(((TorchFloatStorage)storage).data, storage.size());
                break;
            }
            case "torch.DoubleStorage": {
                this.writeS64(storage.size());
                this.writeArrayDouble(((TorchDoubleStorage)storage).data, storage.size());
                break;
            }
            case "torch.ByteStorage": {
                this.writeS64(storage.size());
                this.writeArrayByte(((TorchByteStorage)storage).data, storage.size());
                break;
            }
            case "torch.CharStorage": {
                this.writeS64(storage.size() * 2 + storage.size() % 2);
                this.writeArrayChar(((TorchCharStorage)storage).data, storage.size());
                break;
            }
            default: {
                throw new IOException("Unsupported storage type.  Please add support " + storage.torchName);
            }
        }
    }

    protected void serializeTensor(TorchTensor object) throws IOException {
        this.writeS32(object.shape.length);
        if (object.shape.length > 0) {
            this.writeShape(object.shape);
            int[] stride = new int[object.shape.length];
            int N = 1;
            for (int i = object.shape.length - 1; i >= 0; --i) {
                stride[i] = N;
                N *= object.shape[i];
            }
            this.writeShape(stride);
            this.writeS64(object.startIndex + 1);
            this.serializeObject(object.storage);
        } else {
            this.writeS32(0);
            this.writeS64(0L);
        }
    }

    protected void serializeTable(TorchGeneric object) throws IOException {
        ArrayList<Object> keys = new ArrayList<Object>(object.map.keySet());
        this.writeS32(this.savedObjects.size() + 1);
        this.savedObjects.add(object);
        this.writeS32(keys.size());
        for (Object e : keys) {
            TorchObject t;
            if (e instanceof String) {
                t = new TorchString();
                t.message = (String)e;
                this.serializeObject(t);
            } else if (e instanceof Double) {
                t = new TorchNumber();
                ((TorchNumber)t).value = (Double)e;
                this.serializeObject(t);
            } else {
                throw new RuntimeException("Keys of this type not yet supported or this is a bug. " + e.getClass().getSimpleName());
            }
            this.serializeObject(object.map.get(e));
        }
    }

    protected void serializeList(TorchList object) throws IOException {
        this.writeS32(this.savedObjects.size() + 1);
        this.savedObjects.add(object);
        this.writeS32(object.list.size());
        for (int i = 0; i < object.list.size(); ++i) {
            TorchNumber key = new TorchNumber();
            key.value = i + 1;
            this.serializeObject(key);
            this.serializeObject(object.list.get(i));
        }
    }

    public abstract void writeShape(int[] var1) throws IOException;

    public abstract void writeType(TorchType var1) throws IOException;

    public abstract void writeBoolean(boolean var1) throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    public abstract void writeS64(long var1) throws IOException;

    public abstract void writeS32(int var1) throws IOException;

    public abstract void writeU8(int var1) throws IOException;

    public abstract void writeArrayDouble(double[] var1, int var2) throws IOException;

    public abstract void writeArrayFloat(float[] var1, int var2) throws IOException;

    public abstract void writeArrayChar(char[] var1, int var2) throws IOException;

    public abstract void writeArrayByte(byte[] var1, int var2) throws IOException;

    public boolean isVerbose() {
        return this.verbose;
    }

    public SerializeTorch7 setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }
}

