/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public abstract class BaseOutputLayerSpace<L extends BaseOutputLayer>
extends FeedForwardLayerSpace<L> {
    protected ParameterSpace<ILossFunction> lossFunction;

    protected BaseOutputLayerSpace(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
    }

    protected void setLayerOptionsBuilder(BaseOutputLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.lossFunction != null) {
            builder.lossFunction((ILossFunction)this.lossFunction.getValue(values));
        }
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.lossFunction != null) {
            list.addAll(this.lossFunction.collectLeaves());
        }
        return list;
    }

    public ParameterSpace<ILossFunction> getLossFunction() {
        return this.lossFunction;
    }

    public void setLossFunction(ParameterSpace<ILossFunction> lossFunction) {
        this.lossFunction = lossFunction;
    }

    @Override
    public String toString() {
        return "BaseOutputLayerSpace(lossFunction=" + this.getLossFunction() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOutputLayerSpace)) {
            return false;
        }
        BaseOutputLayerSpace other = (BaseOutputLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<ILossFunction> this$lossFunction = this.getLossFunction();
        ParameterSpace<ILossFunction> other$lossFunction = other.getLossFunction();
        return !(this$lossFunction == null ? other$lossFunction != null : !this$lossFunction.equals(other$lossFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseOutputLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<ILossFunction> $lossFunction = this.getLossFunction();
        result = result * 59 + ($lossFunction == null ? 43 : $lossFunction.hashCode());
        return result;
    }

    protected BaseOutputLayerSpace() {
    }

    public static class LossFunctionParameterSpace
    implements ParameterSpace<ILossFunction> {
        private final ParameterSpace<LossFunctions.LossFunction> lossFunctionParameterSpace;

        public LossFunctionParameterSpace(ParameterSpace<LossFunctions.LossFunction> lossFunctionParameterSpace) {
            this.lossFunctionParameterSpace = lossFunctionParameterSpace;
        }

        public ILossFunction getValue(double[] parameterValues) {
            return ((LossFunctions.LossFunction)this.lossFunctionParameterSpace.getValue(parameterValues)).getILossFunction();
        }

        public int numParameters() {
            return this.lossFunctionParameterSpace.numParameters();
        }

        public List<ParameterSpace> collectLeaves() {
            return this.lossFunctionParameterSpace.collectLeaves();
        }

        public boolean isLeaf() {
            return this.lossFunctionParameterSpace.isLeaf();
        }

        public void setIndices(int ... indices) {
            this.lossFunctionParameterSpace.setIndices(indices);
        }
    }

    public static abstract class Builder<T>
    extends FeedForwardLayerSpace.Builder<T> {
        protected ParameterSpace<ILossFunction> lossFunction;

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction((ParameterSpace<LossFunctions.LossFunction>)new FixedValue((Object)lossFunction));
        }

        public T lossFunction(ParameterSpace<LossFunctions.LossFunction> lossFunction) {
            return this.iLossFunction(new LossFunctionParameterSpace(lossFunction));
        }

        public T iLossFunction(ILossFunction lossFunction) {
            return this.iLossFunction((ParameterSpace<ILossFunction>)new FixedValue((Object)lossFunction));
        }

        public T iLossFunction(ParameterSpace<ILossFunction> lossFunction) {
            this.lossFunction = lossFunction;
            return (T)this;
        }
    }
}

