/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;

public abstract class FeedForwardLayerSpace<L extends FeedForwardLayer>
extends LayerSpace<L> {
    protected ParameterSpace<Integer> nIn;
    protected ParameterSpace<Integer> nOut;

    protected FeedForwardLayerSpace(Builder builder) {
        super(builder);
        this.nIn = builder.nIn;
        this.nOut = builder.nOut;
    }

    protected void setLayerOptionsBuilder(FeedForwardLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.nIn != null) {
            builder.nIn(((Integer)this.nIn.getValue(values)).intValue());
        }
        if (this.nOut != null) {
            builder.nOut(((Integer)this.nOut.getValue(values)).intValue());
        }
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.nIn != null) {
            list.addAll(this.nIn.collectLeaves());
        }
        if (this.nOut != null) {
            list.addAll(this.nOut.collectLeaves());
        }
        return list;
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    protected String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        if (this.nIn != null) {
            sb.append("nIn: ").append(this.nIn).append(delim);
        }
        if (this.nOut != null) {
            sb.append("nOut: ").append(this.nOut).append(delim);
        }
        sb.append(super.toString(delim));
        return sb.toString();
    }

    public ParameterSpace<Integer> getNIn() {
        return this.nIn;
    }

    public ParameterSpace<Integer> getNOut() {
        return this.nOut;
    }

    public void setNIn(ParameterSpace<Integer> nIn) {
        this.nIn = nIn;
    }

    public void setNOut(ParameterSpace<Integer> nOut) {
        this.nOut = nOut;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardLayerSpace)) {
            return false;
        }
        FeedForwardLayerSpace other = (FeedForwardLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Integer> this$nIn = this.getNIn();
        ParameterSpace<Integer> other$nIn = other.getNIn();
        if (this$nIn == null ? other$nIn != null : !this$nIn.equals(other$nIn)) {
            return false;
        }
        ParameterSpace<Integer> this$nOut = this.getNOut();
        ParameterSpace<Integer> other$nOut = other.getNOut();
        return !(this$nOut == null ? other$nOut != null : !this$nOut.equals(other$nOut));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<Integer> $nIn = this.getNIn();
        result = result * 59 + ($nIn == null ? 43 : $nIn.hashCode());
        ParameterSpace<Integer> $nOut = this.getNOut();
        result = result * 59 + ($nOut == null ? 43 : $nOut.hashCode());
        return result;
    }

    protected FeedForwardLayerSpace() {
    }

    public static abstract class Builder<T>
    extends LayerSpace.Builder<T> {
        protected ParameterSpace<Integer> nIn;
        protected ParameterSpace<Integer> nOut;

        public T nIn(int nIn) {
            return this.nIn((ParameterSpace<Integer>)new FixedValue((Object)nIn));
        }

        public T nIn(ParameterSpace<Integer> nIn) {
            this.nIn = nIn;
            return (T)this;
        }

        public T nOut(int nOut) {
            return this.nOut((ParameterSpace<Integer>)new FixedValue((Object)nOut));
        }

        public T nOut(ParameterSpace<Integer> nOut) {
            this.nOut = nOut;
            return (T)this;
        }
    }
}

