/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.PoolingType;

public class GlobalPoolingLayerSpace
extends LayerSpace<GlobalPoolingLayer> {
    protected ParameterSpace<int[]> poolingDimensions;
    protected ParameterSpace<Boolean> collapseDimensions;
    protected ParameterSpace<PoolingType> poolingType;
    protected ParameterSpace<Integer> pNorm;
    private int numParameters;

    private GlobalPoolingLayerSpace(Builder builder) {
        super(builder);
        this.poolingDimensions = builder.poolingDimensions;
        this.collapseDimensions = builder.collapseDimensions;
        this.poolingType = builder.poolingType;
        this.pNorm = builder.pNorm;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    public GlobalPoolingLayer getValue(double[] parameterValues) {
        GlobalPoolingLayer.Builder builder = new GlobalPoolingLayer.Builder();
        super.setLayerOptionsBuilder((Layer.Builder)builder, parameterValues);
        if (this.poolingDimensions != null) {
            builder.poolingDimensions((int[])this.poolingDimensions.getValue(parameterValues));
        }
        if (this.collapseDimensions != null) {
            builder.collapseDimensions(((Boolean)this.collapseDimensions.getValue(parameterValues)).booleanValue());
        }
        if (this.poolingType != null) {
            builder.poolingType((PoolingType)this.poolingType.getValue(parameterValues));
        }
        if (this.pNorm != null) {
            builder.pnorm(((Integer)this.pNorm.getValue(parameterValues)).intValue());
        }
        return builder.build();
    }

    @Override
    public int numParameters() {
        return this.numParameters;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> out = super.collectLeaves();
        if (this.poolingDimensions != null) {
            out.addAll(this.poolingDimensions.collectLeaves());
        }
        if (this.collapseDimensions != null) {
            out.addAll(this.collapseDimensions.collectLeaves());
        }
        if (this.poolingType != null) {
            out.addAll(this.poolingType.collectLeaves());
        }
        if (this.pNorm != null) {
            out.addAll(this.pNorm.collectLeaves());
        }
        return out;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non-leaf parameter space");
    }

    public ParameterSpace<int[]> getPoolingDimensions() {
        return this.poolingDimensions;
    }

    public ParameterSpace<Boolean> getCollapseDimensions() {
        return this.collapseDimensions;
    }

    public ParameterSpace<PoolingType> getPoolingType() {
        return this.poolingType;
    }

    public ParameterSpace<Integer> getPNorm() {
        return this.pNorm;
    }

    @Override
    public int getNumParameters() {
        return this.numParameters;
    }

    public void setPoolingDimensions(ParameterSpace<int[]> poolingDimensions) {
        this.poolingDimensions = poolingDimensions;
    }

    public void setCollapseDimensions(ParameterSpace<Boolean> collapseDimensions) {
        this.collapseDimensions = collapseDimensions;
    }

    public void setPoolingType(ParameterSpace<PoolingType> poolingType) {
        this.poolingType = poolingType;
    }

    public void setPNorm(ParameterSpace<Integer> pNorm) {
        this.pNorm = pNorm;
    }

    @Override
    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    @Override
    public String toString() {
        return "GlobalPoolingLayerSpace(poolingDimensions=" + this.getPoolingDimensions() + ", collapseDimensions=" + this.getCollapseDimensions() + ", poolingType=" + this.getPoolingType() + ", pNorm=" + this.getPNorm() + ", numParameters=" + this.getNumParameters() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalPoolingLayerSpace)) {
            return false;
        }
        GlobalPoolingLayerSpace other = (GlobalPoolingLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<int[]> this$poolingDimensions = this.getPoolingDimensions();
        ParameterSpace<int[]> other$poolingDimensions = other.getPoolingDimensions();
        if (this$poolingDimensions == null ? other$poolingDimensions != null : !this$poolingDimensions.equals(other$poolingDimensions)) {
            return false;
        }
        ParameterSpace<Boolean> this$collapseDimensions = this.getCollapseDimensions();
        ParameterSpace<Boolean> other$collapseDimensions = other.getCollapseDimensions();
        if (this$collapseDimensions == null ? other$collapseDimensions != null : !this$collapseDimensions.equals(other$collapseDimensions)) {
            return false;
        }
        ParameterSpace<PoolingType> this$poolingType = this.getPoolingType();
        ParameterSpace<PoolingType> other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !this$poolingType.equals(other$poolingType)) {
            return false;
        }
        ParameterSpace<Integer> this$pNorm = this.getPNorm();
        ParameterSpace<Integer> other$pNorm = other.getPNorm();
        if (this$pNorm == null ? other$pNorm != null : !this$pNorm.equals(other$pNorm)) {
            return false;
        }
        return this.getNumParameters() == other.getNumParameters();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GlobalPoolingLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<int[]> $poolingDimensions = this.getPoolingDimensions();
        result = result * 59 + ($poolingDimensions == null ? 43 : $poolingDimensions.hashCode());
        ParameterSpace<Boolean> $collapseDimensions = this.getCollapseDimensions();
        result = result * 59 + ($collapseDimensions == null ? 43 : $collapseDimensions.hashCode());
        ParameterSpace<PoolingType> $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : $poolingType.hashCode());
        ParameterSpace<Integer> $pNorm = this.getPNorm();
        result = result * 59 + ($pNorm == null ? 43 : $pNorm.hashCode());
        result = result * 59 + this.getNumParameters();
        return result;
    }

    private GlobalPoolingLayerSpace() {
    }

    public static class Builder
    extends LayerSpace.Builder<Builder> {
        protected ParameterSpace<int[]> poolingDimensions;
        protected ParameterSpace<Boolean> collapseDimensions;
        protected ParameterSpace<PoolingType> poolingType;
        protected ParameterSpace<Integer> pNorm;

        public Builder poolingDimensions(int ... poolingDimensions) {
            return this.poolingDimensions((ParameterSpace<int[]>)new FixedValue((Object)poolingDimensions));
        }

        public Builder poolingDimensions(ParameterSpace<int[]> poolingDimensions) {
            this.poolingDimensions = poolingDimensions;
            return this;
        }

        public Builder collapseDimensions(boolean collapseDimensions) {
            return this.collapseDimensions((ParameterSpace<Boolean>)new FixedValue((Object)collapseDimensions));
        }

        public Builder collapseDimensions(ParameterSpace<Boolean> collapseDimensions) {
            this.collapseDimensions = collapseDimensions;
            return this;
        }

        public Builder poolingType(PoolingType poolingType) {
            return this.poolingType((ParameterSpace<PoolingType>)new FixedValue((Object)poolingType));
        }

        public Builder poolingType(ParameterSpace<PoolingType> poolingType) {
            this.poolingType = poolingType;
            return this;
        }

        public Builder pNorm(int pNorm) {
            return this.pNorm((ParameterSpace<Integer>)new FixedValue((Object)pNorm));
        }

        public Builder pNorm(ParameterSpace<Integer> pNorm) {
            this.pNorm = pNorm;
            return this;
        }

        @Override
        public GlobalPoolingLayerSpace build() {
            return new GlobalPoolingLayerSpace(this);
        }
    }
}

