/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.GravesBidirectionalLSTM;

public class GravesBidirectionalLSTMLayerSpace
extends FeedForwardLayerSpace<GravesBidirectionalLSTM> {
    private ParameterSpace<Double> forgetGateBiasInit;

    private GravesBidirectionalLSTMLayerSpace(Builder builder) {
        super(builder);
        this.forgetGateBiasInit = builder.forgetGateBiasInit;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    public GravesBidirectionalLSTM getValue(double[] values) {
        GravesBidirectionalLSTM.Builder b = new GravesBidirectionalLSTM.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(GravesBidirectionalLSTM.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.forgetGateBiasInit != null) {
            builder.forgetGateBiasInit(((Double)this.forgetGateBiasInit.getValue(values)).doubleValue());
        }
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.forgetGateBiasInit != null) {
            list.addAll(this.forgetGateBiasInit.collectLeaves());
        }
        return list;
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("GravesBidirectionalLSTMLayerSpace(");
        if (this.forgetGateBiasInit != null) {
            sb.append("forgetGateBiasInit: ").append(this.forgetGateBiasInit).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<Double> getForgetGateBiasInit() {
        return this.forgetGateBiasInit;
    }

    public void setForgetGateBiasInit(ParameterSpace<Double> forgetGateBiasInit) {
        this.forgetGateBiasInit = forgetGateBiasInit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GravesBidirectionalLSTMLayerSpace)) {
            return false;
        }
        GravesBidirectionalLSTMLayerSpace other = (GravesBidirectionalLSTMLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$forgetGateBiasInit = this.getForgetGateBiasInit();
        ParameterSpace<Double> other$forgetGateBiasInit = other.getForgetGateBiasInit();
        return !(this$forgetGateBiasInit == null ? other$forgetGateBiasInit != null : !this$forgetGateBiasInit.equals(other$forgetGateBiasInit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GravesBidirectionalLSTMLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<Double> $forgetGateBiasInit = this.getForgetGateBiasInit();
        result = result * 59 + ($forgetGateBiasInit == null ? 43 : $forgetGateBiasInit.hashCode());
        return result;
    }

    private GravesBidirectionalLSTMLayerSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        private ParameterSpace<Double> forgetGateBiasInit;

        public Builder forgetGateBiasInit(double forgetGateBiasInit) {
            return this.forgetGateBiasInit((ParameterSpace<Double>)new FixedValue((Object)forgetGateBiasInit));
        }

        public Builder forgetGateBiasInit(ParameterSpace<Double> forgetGateBiasInit) {
            this.forgetGateBiasInit = forgetGateBiasInit;
            return this;
        }

        @Override
        public GravesBidirectionalLSTMLayerSpace build() {
            return new GravesBidirectionalLSTMLayerSpace(this);
        }
    }
}

